<?php

namespace App\Console\Commands;

use App\Models\Order;
use App\Services\CourierApi;
use App\Services\LogTracker;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class orderStatusTracking extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'order:orderStatusTracking';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command for order Status Tracking with courier ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
      
        try {
            Order::whereIn('status', [4, 10])
                ->whereNotNull('tracking_id')
                ->orderBy('id', 'desc')
                ->chunkById(100, function ($orders) {
                    foreach ($orders as $order) {
                        
                        try {
                            DB::beginTransaction();
                            if ($order->courier_id ==  14) {
                                $response = (new CourierApi())->tracking($order->tracking_id, 'steadfast');
                                if (!empty($response)) {
                                    if ($response['delivery_status'] == 'delivered') {
                                        $order->status = 5;
                                    } else if ($response['delivery_status'] == 'partial_delivered') {
                                        $order->status = 10;
                                    } else if ($response['delivery_status'] == 'cancelled') {
                                        $order->status = 11;
                                    }
                                    if ($order->isDirty('status')) {
                                        $order->save();
                                    }
                                }
                            }
                            if ($order->courier_id == 7) {
                                $response = (new CourierApi())->tracking($order->tracking_id, 'pathao');
                                if (!empty($response)) {
                                    if (isset($response['data'])) {
                                        $parcel = $response['data'];

                                        if ($parcel['order_status'] == 'Delivered') {
                                            $order->status = 5;
                                        } elseif ($parcel['order_status'] == 'Partial Delivery') {
                                            $order->status = 10;
                                        } elseif ($parcel['order_status'] == 'Return') {
                                            $order->status = 11; 
                                        }
                                        if ($order->isDirty('status')) {
                                            $order->save();
                                        }
                                        LogTracker::successLog("Response pathao: " . json_encode($parcel)
                                            . ' for order invoice: ' . $order->invoice_no);
                                    } else {
                                        LogTracker::infoLog("Response without 'data' from pathao: " . json_encode($response)
                                            . ' for order invoice: ' . $order->invoice_no);
                                    }

                                }
                            }
                         DB::commit();
                        } catch (\Throwable $th) {
                            DB::rollBack();
                            LogTracker::failLog($th, null);
                        }
                    }
                });
            LogTracker::infoLog(' tracking completed');
            return true;
        } catch (\Throwable $th) {
            LogTracker::failLog($th, null);
            return false;
        }
    }
}
