<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\Exportable;

class OrdersExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    use Exportable;

    protected $orders;
    protected $headers;

    public function __construct(array $orders, array $headers)
    {
        $this->orders = $orders;
        $this->headers = $headers;
    }

    public function collection()
    {
        return collect($this->orders);
    }

    public function headings(): array
    {
        return $this->headers;
    }
}

