<?php

namespace App\Exports;

use App\Models\Supplier;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;


class SupplierExport implements FromCollection , WithHeadings , ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $collections = Supplier::all();

        foreach($collections as  $item){
            unset($item->id,$item->name,$item->status,$item->type,$item->created_at,$item->updated_at );
             $collections[]=$item;
         }

        return $collections;

    }
     
    public function headings():  array
    {
        return self::columnWidths('Company Name','Phone','Address');
    }
 

    public static function  columnWidths($company_name, $phone, $address): array 
    {
        return [ 
            $company_name, $phone, $address
        ];
    }



}
