<?php

namespace App\Filters;

use App\Models\Order;

class OrderFilter
{

    public static function adminOrderFilter($data)
    {
        $query = Order::with([
            'customer:id,name,address,status,total_order,is_blocked',
            'assignedTo:id,name',
            'createAdmin:id,name',
            'updateAdmin:id,name,image',
            'approvedBy:id,name',
            'packagingBy:id,name',
            'courier:id,name,image',
            'orderItem.product:id,name,thumbnail_img,product_code',
            'orderItem.OrderItemVariant',
            'source:id,name',
            'reseller:id,name,phone'
        ]);
        /* ========= search filter ========= */
        if ($data->query('search')) {

            if ($data->search_type == 1) {

                $query->where(function ($q) use ($data) {
                    $q->where('invoice_no', 'LIKE', "%{$data->search}%")
                        ->orWhere('customer_phone', 'LIKE', "%{$data->search}%")
                        ->orWhere('tracking_id', 'LIKE', "%{$data->search}%");
                });
            } else if ($data->search_type == 2) {
                $search = $data->search;
                $query->WhereHas('orderItems.product', function ($query) use ($search) {
                    $query->where('code', $search);
                })
                    ->paginate(250);
            }
        }
        $is_super_admin = session()->get('admin')['is_super_admin'] == 1;
        if (!$is_super_admin) {
            $query->where('assigned_admin_id', session()->get('admin')['id']);
        }

        /* ========= status filter ========= */
        if ($data->query('status')) {
            if ($data->query('status') != 'all') {
                $query->where('status', $data->status);
            }
        }
        /* ========= type filter ========= */
        if ($data->query('type')) {
            if ($data->query('type') != 'all') {
                $query->where('order_type', $data->type);
            }
        }
        /* ========= start date filter ========= */
        if (!empty($data->query('start_date')) && empty($data->query('end_date'))) {
            $query->whereDate('created_at', '=', $data->start_date);
        }
        /* ========= start date & end date filter ========= */
        if (!empty($data->query('start_date')) && !empty($data->query('end_date'))) {
            $query->whereDate('created_at', '>=', $data->start_date)
                ->whereDate('created_at', '<=', $data->end_date);
        }
        /* ========= courier filter ========= */
        if (!empty($data->query('courier_id'))) {
            $query->where('courier_id', $data->courier_id);
        }
        /* ========= city filter ========= */
        if (!empty($data->query('city_id'))) {
            $query->where('city_id', $data->city_id);
        }
        /* ========= source filter ========= */
        if (!empty($data->query('order_source'))) {
            $query->where('order_source', $data->order_source);
        }
        if (!empty($data->query('approved_admin_id'))) {
            $query->where('approved_admin_id', $data->approved_admin_id);
        }
        if (!empty($data->query('assigned_admin_id'))) {
            $query->where('assigned_admin_id', $data->assigned_admin_id);
        }
        return $query;
    }
}
