<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AamarpayConfiguration;

class AamarpayController extends Controller
{
    public function getAmarpayInfo()
    {
        $information      =  AamarpayConfiguration::first();

        return response()->json([
            'status'      => true,
            'information' => $information
        ]);
    }
    public function updateAmarpayInfo(Request $request)
    {

        $data               =  $request->validate([
            'store_id'      => 'required|string',
            'signature_key' => 'required|string',
        ]);

        $amarpaySetting     =  AamarpayConfiguration::first();
        if ($amarpaySetting) {
            $amarpaySetting->update($data);
        } else {
            AamarpayConfiguration::create($data);
        };
        return response()->json([
            'status'  => true,
            'message' => 'Amarpay Configuration Updated Successfully'
        ]);
    }

    public function updateAmarpayStatus(Request $request){
        $amarpaySetting = AamarpayConfiguration::first();

        if($request->status==0){
            $amarpaySetting->status=0;
            $amarpaySetting->save();
            $message = 'Aamarpay De-activated successfully';
        }
        else{
            $amarpaySetting->status=1;
            $amarpaySetting->save();
            $message = 'Aamarpay Ativated successfully';
        }
        return response()->json([
            'status' => true,
            'message' => $message
        ]);
    }
}
