<?php

namespace App\Http\Controllers\Admin;

use App\Models\Attribute;
use App\Models\Variant;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
class AttributeAndVariantController extends Controller
{
    
    public function index()
    {
        $attributes = Attribute::orderBy('id', 'DESC')->get();
        return response()->json([
            'attributes' => $attributes,
            'status' => 'SUCCESS'
        ]);
    }


    
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:attributes',

        ]);
        $attribute = new Attribute();
        $attribute->name = $request->name;
        if ($attribute->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'attribute add successfully'
            ]);
        }
    }


  
    public function edit($id)
    {
        $attribute=Attribute::findOrFail($id);
        return response()->json([
            'attribute' => $attribute ,
        ]);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:attributes,name,'.$id,
        ]);
        $attribute = Attribute::findOrFail($id);
        $attribute->name = $request->name;
        if ($attribute->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'attribute changed'
            ]);
        }
    }


    

    public function active($id)
    {

        $attribute = Attribute::find($id);
        $attribute->status = 1;
        if ($attribute->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'attribute active successfully'
            ]);
        }

    }

    public function deActive($id)
    {

        $attribute = Attribute::find($id);
        $attribute->status = 0;
        if ($attribute->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'attribute de-active successfully'
            ]);
        }
    }


    public function deleteAtrribute($id){
        $attribute = Attribute::findOrFail($id);
        if (!$attribute) {
            return response()->json(['message' => 'Attribute not found'], 404);
        }
    
        if ($attribute->variants()->count() === 0) {
            $attribute->delete();
            return response()->json(['status' => true, 'message' => 'Attribute deleted successfully'], 200);
        } else {
            return response()->json(['message' => 'Attribute is not empty. Delete associated variant first.'], 400);
        }
    }




    public function variant()
    {
        
        $variants = Variant::orderBy('id', 'DESC')->with('attribute')->get();
        return response()->json([
            'variants' => $variants,
            'status' => 'SUCCESS'
        ]);
    }

    public function activeVariant($id)
    {

        $variant = Variant::find($id);
        $variant->status = 1;
        if ($variant->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'variant active successfully'
            ]);
        }

    }

    public function deActiveVariant($id)
    {

        $variant = Variant::find($id);
        $variant->status = 0;
        if ($variant->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'variant de-active successfully'
            ]);
        }

    }

    public function storeVariant(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:variants',
            'attribute' => 'required',
        ]);
        $variant = new Variant();
        $variant->name = Str::upper($request->name);
        $variant->attribute_id = $request->attribute;
        if ($variant->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Variant add successfully'
            ]);
        }
    }




    public  function attributeWiseVariant($id){
        // return $id;
        $variants = Variant::where('attribute_id', $id)->get();
        if ($variants){
            return response()->json([
                'status' => 'SUCCESS',
                'variants' => $variants
            ]);
        }

    }


    
    public function  getVariantItem($id){

        $variant= Variant::findOrFail($id);
        return \response()->json([
            'variant'=> $variant ,
        ]);
    }
    

    public function updateVariant(Request $request,$id)
    {
        $this->validate($request, [
            'name' => 'required|unique:variants,name,'.$id,
            'attribute' => 'required',

        ]);
        $variant = Variant::findOrFail($id);
        $variant->name = Str::upper($request->name);
        $variant->attribute_id = $request->attribute;
        if ($variant->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Variant updated'
            ]);
        }
    }



    public function deleteVariant($id){
        $variant = Variant::findOrFail($id);
        if (!$variant) {
            return response()->json(['message' => 'Variant not found'], 404);
        }
    
        if ($variant->productVariants()->count() === 0) {
            $variant->delete();
            return response()->json(['status' => true, 'message' => 'Variant deleted successfully'], 200);
        } else {
            return response()->json(['message' => 'Variant is not empty. Delete associated product first.'], 400);
        }
    }


    
}
