<?php

namespace App\Http\Controllers\Admin;

use App\Models\Author;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AuthorController extends Controller{
    public function index()
    {
        $authors = Author::orderby('id', 'desc')->paginate(10);
        return response()->json([
            'authors' => $authors,
            'status' => 'SUCCESS'
        ]);
    }
    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|unique:authors',
            'description' => 'required|unique:authors',
            'meta_title' => 'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content' => 'nullable',
        ]);
        $slug = explode(" ", $request->name);
        $author = new Author();
        $author->name = $request->name;
        $author->description = $request->description;
        $author->slug = Str::slug($author->name);
        $author->status = 1;
        $author->meta_title = $request->meta_title;
        $author->meta_description = $request->meta_description;
        $author->meta_key = $request->meta_key;
        $author->meta_content = $request->meta_content;

        if ($request->hasFile('image')) {
            $validatedData = $request->validate([
                //'image' => 'required|file|image|dimensions:max_width=1000,max_height=1000',
            ]);
            // $path = $request->file('image')->store('images/author', 'public');
            $path = $request->file('image')->store('images/author', 'public');
            $author->image = $path;
        }
        if ($author->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Author added successfully'
            ]);
        }
    }

    public function active($id)
    {
        $author = Author::find($id);
        if ($author) {
            $author->status = 1;
            if ($author->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'author actived successfully'
                ]);
            }
        }
    }
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name' => 'required|unique:authors,name,' .$id,
            // 'description' => 'required|unique:authors',
            'meta_title' => 'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content' => 'nullable',
        ]);
        // $slug = explode(" ", $request->name);
        $author = Author::find($id);;
        $author->name = $request->name;
        $author->description = $request->description;
        $author->slug = Str::slug($author->name);
        $author->status = 1;
        $author->meta_title = $request->meta_title;
        $author->meta_description = $request->meta_description;
        $author->meta_key = $request->meta_key;
        $author->meta_content = $request->meta_content;

        if ($request->hasFile('image')) {
            // $validatedData = $request->validate([]);
            $path = $request->file('image')->store('images/author', 'public');
            $author->image = $path;
        }
        if ($author->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Author updated successfully'
            ]);
        }
    }

    public function deActive($id)
    {
        $author = Author::find($id);
        if ($author) {
            $author->status = 0;
            if ($author->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'author de-actived successfully'
                ]);
            }
        }
    }
    public function edit($id)
    {
        $author = Author::find($id);
        if ($author) {
            return response()->json([
                'status' => 'SUCCESS',
                'author' => $author
            ]);
        }
    }
    // public function search($search)
    // {
    //     $author = Author::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

    //     if ($author) {
    //         return response()->json([
    //             'author' => $author,
    //             'status' => 'SUCCESS'
    //         ]);
    //     }
    // }
    public function search($search)
    {
        $authors = Author::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

        if ($authors) {
            return response()->json([
                'authors' => $authors,
                'status' => true
            ]);
        }
    }
    public function getAuthorName()
    {
        $authors = Author::where('status', 1)->get();
        return response()->json([
            'success' => true,
            'authors' => $authors,
        ]);
    }
}
