<?php

namespace App\Http\Controllers\Admin;

use Throwable;
use App\Models\Balance;
use Illuminate\Http\Request;
use App\Models\BillPerMonth;
use App\Models\BillStatement;
use App\Models\BillPaidStatement;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class BillStatementController extends Controller
{
  public function balance()
  {

    $balance = Balance::where('status',1)->get();
    return response()->json([
      'success' => 'OK',
      'balance' => $balance
    ]);
  }


  public function status($id)
  {
    $bill = BillStatement::findOrFail($id);
    if ($bill->status == 1) {
      $bill->status = 0;
    } else {
      $bill->status = 1;
    }
    $bill->save();
    return response()->json([
      'status' => true,
      'message' => 'updated successfully'
    ]);
  }




  public function bill_list()
  {
    $bills = BillStatement::all();
    return response()->json([
      'success' => 'OK',
      'bills' => $bills
    ]);
  }


  public function edit($id)
  {
    $bill = BillStatement::find($id);
    return sendResponseWithData('bill', $bill, true);
  }


  public function activeBillList()
  {
    $bills = BillStatement::where('status', 1)->orderBy('name')->get();
    return response()->json([
      'success' => 'OK',
      'bills' => $bills
    ]);
  }



  public function store(Request $request)
  {

    $validatedData = $request->validate([
      'name' => 'required|unique:bill_statements',
      // 'company_name' => 'required',
      // 'mobile_no' => 'required|digits:11|unique:bill_statements',
      // 'address' => "required",
    ]);

    $bill = new BillStatement();
    $bill->name = $request->name;
    // $bill->company_name = $request->company_name;
    // $bill->mobile_no = $request->mobile_no;
    // $bill->address = $request->address;
    $bill->save();
    return response()->json([
      'status' => 'OK',
      'message' => 'Added successfully'
    ]);
  }


  public function update(Request $request, $id)
  {
    $request->validate([
      'name' => 'required|unique:bill_statements,name,'.$id,
      // 'company_name' => 'required',
      // 'mobile_no' => 'required',
      // 'address' => "required",
    ]);

    $bill = BillStatement::find($id);
    $bill->name = $request->name;
    // $bill->company_name = $request->company_name;
    // $bill->mobile_no = $request->mobile_no;
    // $bill->address = $request->address;
    $bill->save();
    return response()->json([
      'status' => 'OK',
      'message' => 'Updated successfully'
    ]);
  }



  public function bill_statement_details($id)
  {

    $bill_statement = BillStatement::findOrFail($id);
    $bill_history = BillPaidStatement::orderBy('id', 'desc')->where('bill_statement_id', $id)->paginate(30);
    $total_bill = BillPaidStatement::where('bill_statement_id', $id)->sum('amount');
    //per month history
    $per_month_history = BillPerMonth::where('bill_statement_id', $id)->get();
    $per_month_total = BillPerMonth::where('bill_statement_id', $id)->sum('amount');

    return response()->json([
      'bill_statement' => $bill_statement,
      'bill_history' => $bill_history,
      'total_bill' => $total_bill,
      'per_month_history' => $per_month_history,
      'per_month_total' => $per_month_total,
    ]);
  }




  public function store_bill_per_month(Request $request)
  {
    // return $request->all();
    $request->validate([
      'amount' => 'required',
      'bill_statement_id' => 'required',
      'month' => 'required',
      'date' => 'required',
    ]);

    $bill = new BillPerMonth();
    $bill->bill_statement_id = $request->bill_statement_id;
    $bill->date = $request->date;
    $bill->month = $request->month;
    $bill->comment = $request->comment;
    $bill->amount = $request->amount;
    $bill->save();

    return response()->json([
      'status' => 'OK',
      'message' => 'Added successfully'
    ]);
  }
}
