<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Brand;
use Illuminate\Support\Str;
class BrandController extends Controller
{
    public function index()
    {
        $brands = Brand::orderby('id', 'desc')->paginate(40);
        return response()->json([
            'brands' => $brands,
            'status' => 'SUCCESS'
        ]);
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|unique:brands,name',
        ]);
        $id = Brand::max('id') ?? 1;
        $brand = new Brand();
        $brand->name = $request->name;
        $brand->slug = Str::slug($request->name);
        $brand->status = 1;
        $brand->position = $id + 1;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/brand', 'public');
            $brand->image = $path;
        }
        if ($brand->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Brand add successfully'
            ]);
        }
    }



    public function status($id)
    {
        $brand = Brand::find($id);
        if ($brand->status == 0) {
            $brand->status = 1;
        }else{
            $brand->status = 0;
        }
        $brand->save();
        return sendResponseWithMessage(true, 'Status Changed');
    }

    public function search($search)
    {
        $brands = Brand::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

        if ($brands) {
            return response()->json([
                'brands' => $brands,
                'status' => 'SUCCESS'
            ]);
        }
    }

    public function edit($id)
    {
        $brand = Brand::find($id);
        if ($brand) {
            return response()->json([
                'status' => 'SUCCESS',
                'brand' => $brand
            ]);
        }

    }

    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name'=>'required|unique:brands,name,'.$id,
        ]);
        $brand = Brand::find($id);
        $brand->name = $request->name;
        $brand->position = $request->position;
        $brand->slug = Str::slug($request->name);
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/brand', 'public');
            $brand->image = $path;
        }
        if ($brand->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'brand update successfully'
            ]);
        }
    }
}
