<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Models\SubCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;

class CategoryController extends Controller
{

    public function index()
    {
        $categories = Category::orderby('id', 'desc')->paginate(50);
        return sendResponseWithData('categories', $categories, true);
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|unique:categories',
            'meta_title'=>'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content' => 'nullable',
        ]);
        $id = Category::max('id') ?? 1;
        $category = new Category();
        $category->name = $request->name;
        $category->slug = Str::slug($category->name);
        $category->status = 1;
        $category->position = $id + 1;
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;
        $category->meta_key = $request->meta_key;
        $category->meta_content = $request->meta_content;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/category', 'public');
            $category->icon_image = $path;
        }
        $category->save();
        return sendResponseWithMessage(true, 'category add successfully');
    }

   

    public function status($id)
    {
        $category = Category::find($id);
        if ($category->status == 1) {
            $category->status = 0;
        } else {
            $category->status = 1;
        }
        $category->save();
        return sendResponseWithMessage(true, 'Status Updated');
    }

    public function search($search)
    {
        $categories = Category::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(50);
        return sendResponseWithData('categories', $categories, true);
    }

    public function edit($id)
    {
        $category = Category::find($id);
        return sendResponseWithData('category', $category, true);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:categories,name,'.$id,
            'meta_title'=>'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content' => 'nullable',
        ]);
        $category = Category::find($id);
        $category->name = $request->name;
        $category->position = $request->position;
        $category->slug = Str::slug($category->name);
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;
        $category->meta_key = $request->meta_key;
        $category->meta_content = $request->meta_content;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/category', 'public');
            $category->icon_image = $path;
        }
        $category->save();
        return sendResponseWithMessage(true, 'category update successfully');
    }

    public function categoryWiseSubCategory($id){
        $subCategories = SubCategory::where('category_id',$id)->get();
        if ($subCategories){
            return response()->json([
                'status' => 'SUCCESS',
                'subCategories' =>$subCategories
            ]);
        }
    }



    public function delete($id)
    {
        $category = Category::findOrFail($id);
        if (!$category) {
            return response()->json(['message' => 'Category not found'], 404);
        }
    
        if ($category->product()->count() === 0 && $category->subCategory()->count() === 0 && $category->subSubCategory()->count() === 0) {
            $category->delete();
            return response()->json(['status' => true, 'message' => 'Category deleted successfully'], 200);
        } else {
            return response()->json(['message' => 'Category is not empty. Delete associated products first.'], 400);
        }
    }

}
