<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Country;
use Illuminate\Support\Str;
class CountryController extends Controller
{
    public function index()
    {
        $countries = Country::orderby('id', 'desc')->paginate(30);
        return response()->json([
            'success' => true,
            'countries' => $countries,
        ]);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:countries|',
        ]);
        $country = new Country();
        $country->name = $request->name;
        $country->slug = Str::slug($request->name);
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/country', 'public');
            $country->image = $path;
        }
        if ($country->save()) {
            return response()->json([
                'success' => true,
                'message' => 'Country add successfully'
            ]);
        }
    }

    public function active($id)
    {
        $country = Country::find($id);
        if ($country) {
            $country->status = 1;
            if ($country->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Country active successfully'
                ]);
            }
        }
    }

    public function deActive($id)
    {
        $country = Country::find($id);
        if ($country) {
            $country->status = 0;
            if ($country->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Country de-active successfully'
                ]);
            }
        }
    }

    public function search($search)
    {
        $countries = Country::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

        if ($countries) {
            return response()->json([
                'success' => true,
                'countries' => $countries,
            ]);
        }
    }

    public function edit($id)
    {
        $country = Country::find($id);
        if ($country) {
            return response()->json([
                'success' => true,
                'country' => $country
            ]);
        }
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);
        $country = Country::find($id);
        $country->name = $request->name;
        $country->slug = Str::slug($request->name);
        $country->position = $request->position;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/country', 'public');
            $country->image = $path;
        }
        if ($country->save()) {
            return response()->json([
                'success' => true,
                'message' => 'country update successfully'
            ]);
        }
    }
}
