<?php

namespace App\Http\Controllers\Admin;

use App\Models\Customer;
use App\Exports\CustomersExport;
use App\Exports\DueCustomerExport;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\RetailCustomersExport;
use App\Exports\WholesaleCustomersExport;
use App\Exports\OfficesaleCustomersExport;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
     public function getCustomer(Request $request)
     {
          $filterByIpStatus = $request->filter_by_ip_status;
          if ($filterByIpStatus != '') {
               $customers = Customer::orderBy('id', 'DESC')->with('customerCity:id,name', 'customerSubCity:id,name')->where('is_blocked', $filterByIpStatus)->paginate(50);
          } else {
               $customers = Customer::orderBy('id', 'DESC')->with('customerCity:id,name', 'customerSubCity:id,name')->paginate(50);
          }
          return response()->json([
               'customers' => $customers,
               'status' => 'SUCCESS'
          ]);
     }



     public function searchCustomer($data)
     {
          $customers = Customer::where('name', 'like', '%' . $data . '%')->orWhere('phone', 'like', '%' . $data . '%')->with('customerCity:id,name', 'customerSubCity:id,name')->paginate(50);
          return response()->json([
               'success' => 'OK',
               'customers' => $customers,
          ]);
     }


     public  function export_customers()
     {
          return Excel::download(new CustomersExport(), 'customers.xlsx');
     }



     public  function export_retail_customers()
     {
          return Excel::download(new RetailCustomersExport(), 'retail_customer.xlsx');
     }


     public  function export_wholesale_customers()
     {
          return Excel::download(new WholesaleCustomersExport(), 'wholesale_customer.xlsx');
     }

     public  function export_officesale_customers()
     {
          return Excel::download(new OfficesaleCustomersExport(), 'officesale_customer.xlsx');
     }

     public function status($id)
     {
          $customer = Customer::findOrFail($id);
          if ($customer->status == 1) {
               $customer->status = 0;
          } else {
               $customer->status = 1;
          }
          $customer->save();
          return response()->json([
               'status' => true,
               'message' => 'Status Updated',
          ]);
     }



     public function blockIp($id)
     {
          $customer = Customer::find($id);
          $customers = Customer::where('ip_address', $customer->ip_address)->get();
          foreach($customers as $item){
               $item->is_blocked = 0;
               $item->save();
          }
          return response()->json([
               'status' => true,
               'message' => 'Customer IP blocked Successfully'
          ]);
     }
     public function unblockIp($id)
     {
          $customer = Customer::find($id);
          $customers = Customer::where('ip_address', $customer->ip_address)->get();
          foreach($customers as $item){
               $item->is_blocked = 1;
               $item->save();
          }
          
          return response()->json([
               'status' => true,
               'message' => 'Customer IP Unblocked Successfully'
          ]);
     }
}
