<?php

namespace App\Http\Controllers\Admin;

use App\Services\SmsService;
use App\Http\Controllers\Controller;
use App\Models\Damage;
use App\Models\DamageItem;
use App\Models\Product;
use Illuminate\Http\Request;
// use App\Services\LogTracker;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image;
use Throwable;

class DamageProductController extends Controller
{
    public function index(Request $request)
    {
        $paginate = $request->item ?? 10;
        $status = $request->status ?? 1;
        $damages = Damage::with('items')->orderBy('id', 'ASC')->where('status', $status)->paginate($paginate);
        if ($damages) {
            return response()->json([
                'status' => 'SUCCESS',
                'damage' => $damages,
            ]);
        }
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $damage = new Damage();
            $damage->damage_date = $request->damage_date;
            $damage->total_amount = $request->total_amount;
            $damage->status = $request->status;
            $damage->save();

            if (!empty($request->items)) {  // Changed from 'products' to 'items' to match frontend
                foreach ($request->items as $item) {
                    $p_item = new DamageItem();
                    $p_item->damage_id = $damage->id;
                    $p_item->product_id = $item['product_id'];
                    $p_item->purchase_price = $item['purchase_price']; 
                    $p_item->product_qty = $item['product_qty'];
                    $p_item->save();
                }
            }

            DB::commit();  // Don't forget to commit the transaction

            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Damage record created successfully'
            ]);
        } catch (Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => 'ERROR',
                'message' => $th->getMessage(),
            ], 500);
        }
    }

    public function deleteProductDamage($id)
    {
        DB::beginTransaction();
        try {
            $damage = Damage::findOrFail($id);
            $damage->delete();

            DB::commit();
            return response()->json([
                'status' => true,
                'message' => 'Damage item deleted successfully'
            ]);
        } catch (Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => 'ERROR',
                'message' => $th->getMessage(),
            ], 500);
        }
    }

    public function details($id)
    {
        $damage = Damage::with('items.product')->findOrFail($id);
        if ($damage) {
            return response()->json([
                'status' => true,
                'damage' => $damage,
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Damage Product not found'
            ], 404);
        }
    }
}