<?php

namespace App\Http\Controllers\Admin;

use App\Models\Description;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\LandingPage;

class DescriptionController extends Controller
{
    public function index($slug)
    {
        $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $descriptions = Description::where('landing_page_id', $page->id)->with('landingPage')->orderby('id', 'desc')->get();
        return response()->json([
            'descriptions' => $descriptions,
            'success' => true,
        ]);
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'title' => 'required',
            'landing_page_id' => 'required',
        ]);
        $description = new Description();
        $description->landing_page_id = $request->landing_page_id;
        $description->title = $request->title;
        $description->save();
        return response()->json([
            'success' => true,
            'message' => 'Description added successfully'
        ]);
        
    }

    

    public function status($id)
    {
        $description = Description::find($id);
        if ($description->status == 1) {
            $description->status = 0;
            $description->save();
        }else{
            $description->status = 1;
            $description->save();
        }

        return response()->json([
            'success' => true,
            'message' => 'Description status updated'
        ]);
    }


    public function search($search)
    {
        $descriptions = Description::where('title', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

        if ($descriptions) {
            return response()->json([
                'descriptions' => $descriptions,
                'success' => true,
            ]);
        }
    }

    public function edit($id)
    {
        $description = Description::with('landingPage')->find($id);
        return response()->json([
            'success' => true,
            'description' => $description
        ]);
    }




    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'title' => 'required',
            'landing_page_id' => 'required',
        ]);
        $description = Description::find($id);
        $description->landing_page_id = $request->landing_page_id;
        $description->title = $request->title;
        $description->save();
        return response()->json([
            'success' => true,
            'message' => 'Description update successfully'
        ]);
        
    }



    public function delete($id)
    {
        $description = Description::findOrFail($id);
        $description->delete();
        return response()->json([
            'status' => true,
            'message' => 'Description deleted successfully'
        ]);
    }
}
