<?php

namespace App\Http\Controllers\Admin;

use Exception;
use App\Models\Debit;
use App\Models\Credit;
use App\Models\FondTransfer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class FondTransferController extends Controller
{

    public function index(Request $request)
    {
        $item=$request->items ?? 50;
        $transfer_amount_list = FondTransfer::with('balance', 'balanceTo')->orderBy('id','DESC')->paginate($item);
        return response()->json([
             'status'=>'OK',
             'transactions'=>$transfer_amount_list
        ]);
    }


    public function store(Request $request)
    {
        try{
            DB::beginTransaction();
            $request->validate([
                'from' => 'required ',
                'to' => 'required',
                'amount' => 'required',
            ]);
    
            $found_transfer=new FondTransfer();
            $found_transfer->from=$request->from;
            $found_transfer->to=$request->to;
            $found_transfer->amount=$request->amount;
            $found_transfer->cost=$request->cost;
            $found_transfer->comment=$request->comment ?? null;
            $found_transfer->creator_admin=session()->get('admin')['name'];
            $found_transfer->save();
    
            //create a  debit
            $debit = new Debit();
            $debit->is_fund_transfer = 1;
            $debit->balance_id=$request->from;
            $debit->amount = $request->amount;
            $debit->comment = "Fund Transfer ". $request->from.'-'.$request->to.'. Amount '. $request->amount;
            $debit->date = date('Y-m-d');
            $debit->is_expense =0;
            $debit->insert_admin_id=session()->get('admin')['id'];
            $debit->purpose = 27;
            $debit->save();
    
            //create a credit
            $credit = new Credit();
            $credit->is_fund_transfer = 1;
            $credit->purpose = "Fund Transfer";
            $credit->amount =$request->transfer_amount;
            $credit->balance_id = $request->to;
            $credit->comment ="Fund In ". $request->from.' from '.$request->to.'. Amount '.($request->transfer_amount). '. And Transfer Cost '.($request->amount-$request->transfer_amount);
            $credit->date = date('Y-m-d');
            $credit->insert_admin_id=session()->get('admin')['id'];
            $credit->save();
            DB::commit();
            return sendResponseWithMessage(true, 'Transfer Successfully');
        }catch(Exception $e){
            DB::rollBack();
            return sendResponseWithMessage(false, $e->getMessage());
        }
    }


    public function delete($id)
    {
        $fund_transfer = FondTransfer::findOrFail($id);
        $fund_transfer->delete();
        return sendResponseWithMessage(true, 'Deleted');
    }
}
