<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Credit;
use App\Models\Loan;
use App\Models\Loaner;
use App\Models\LoanPaid;
use Exception;
use Illuminate\Support\Facades\DB;

class LoanController extends Controller
{
    public function index( Request $request)
    {
        $items=$request->item ?? 50;
        $loan=Loaner::orderBy('id','DESC')->paginate($items);
        $total_loan= DB::table('loans')->sum('amount');
        $total_loan_paid= DB::table('loan_paids')->sum('amount');
        $due_amount=$total_loan-$total_loan_paid;

        foreach($loan as $item){
            $item->{'taken_amount'}=Loan::where('loaner_id',$item->id)->sum('amount');
            $item->{'paid_amount'}=LoanPaid::where('loaner_id',$item->id)->sum('amount');
        }
        return response()->json([
            'success'=>'OK',
            'loan'=>$loan,
            'total_loan' => number_format($total_loan),
            'total_loan_paid' => number_format($total_loan_paid),
            'due_amount' =>number_format($due_amount)
        ]);
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'mobile_no' => 'required|digits:11',
            'date'=>"required",
            'purpose'=>"required",
            'amount'=>"required|integer",
            'address'=>"required",
            'balance_id' => 'required',
        ]);
        try{
            DB::beginTransaction();
            $loaner=Loaner::where('mobile_no',$request->mobile_no)->first();
            if(empty($loaner)){
                $loaner=new Loaner();
                $loaner->name=$request->name;
                $loaner->mobile_no=$request->mobile_no;
                $loaner->address=$request->address;
                $loaner->save();
            }

            $loan=new Loan();
            $loan->loaner_id=$loaner->id;
            $loan->purpose=$request->purpose;
            $loan->amount=$request->amount;
            $loan->date=$request->date;
            $loan->save();

            /**** store credit ****/
            $credit = new Credit();
            $credit->purpose = "Loan From ". $request->name;
            $credit->amount = $request->amount;
            $credit->comment = $request->purpose ?? null;
            $credit->date = $request->date;
            $credit->balance_id = $request->balance_id;
            $credit->insert_admin_id=session()->get('admin')['id'];
            $credit->save();
            DB::commit();
            return response()->json([
                'success'=>'OK',
                'message'=>'Loan Add Successfully'
            ]);
            
        }catch(Exception $e){
            DB::rollBack();
            return sendResponseWithMessage(false, $e->getMessage());
        }
        
    }

    public function loaners(){
        $loaners=Loaner::all();
        return response()->json($loaners);
    }

    public function loanersdetails($id){
        $loans=Loan::where('loaner_id',$id)->orderBy('id','desc')->get();
        $loanPaid=LoanPaid::where('loaner_id',$id)->orderBy('id','desc')->get();
        return response()->json([
            'loans'=>$loans,
            'loanPaid'=>$loanPaid
        ]);
    }

    public function storeloan(Request $request, $id){
        try{
            DB::beginTransaction();
            $loaner=Loaner::find($id);
            $loan=new Loan();
            $loan->loaner_id = $loaner->id;
            $loan->purpose = $request->purpose;
            $loan->amount = $request->amount;
            $loan->date = date('Y-m-d');
            $loan->save();

            $credit = new Credit();
            $credit->purpose = "Loan From ". $loaner->name;
            $credit->amount = $request->amount;
            $credit->comment = $request->purpose ?? null;
            $credit->date = date('Y-m-d');
            $credit->balance_id = $request->balance_id;
            $credit->insert_admin_id = session()->get('admin')['id'];
            $credit->save();
            DB::commit();
            return \response()->json([
                'success'=>'OK',
                'message'=>'Loan Add Successfully'
            ]);
            
        }catch(Exception $e){
            DB::rollBack();
            return sendResponseWithMessage(false, $e->getMessage());
        }
        

    }
}
