<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Order;
use Illuminate\Support\Facades\DB;
use App\Services\SmsService;
use App\Models\SmsNumberRecord;
use App\Models\SmsCampaignRecord;
use App\Jobs\SendSmsJob;
use Illuminate\Support\Facades\Bus;
use App\Models\Customer;
use App\Models\Reseller;

class MarketingController extends Controller
{
    public function productList()
    {
        $products = Product::where('status', 1)->select('name', 'id')->get();
        return response()->json([
            'status' => true,
            'products' => $products,
        ]);
    }

    public function getCustomerNumber($request)
    {

        $query = Order::query();

        if ($request->has('product_id') && !empty($request->product_id)) {
            $orderIds = DB::table('order_items')
                ->where('product_id', $request->product_id)
                ->pluck('order_id')
                ->unique()
                ->toArray();


            $query->whereIn('id', $orderIds);
        }

        $customerPhones = $query->pluck('customer_phone')->unique();

        return $customerPhones;
    }
    public function fetchNumberCount(Request $request)
    {

        $request->validate([
            'product_id' => 'nullable|integer'
        ]);

        $customerPhones = $this->getCustomerNumber($request);
        $customerPhonesCount = count($customerPhones);
        if ($customerPhonesCount) {
            return response()->json([
                'status' => true,
                'phones_count' => $customerPhonesCount

            ]);
        }
    }

    public function sendMessage(Request $request)
    {
        // return $request->all();
        if (!empty($request->product_id)) {
            $contact_numbers = $this->getCustomerNumber($request);
        } elseif (!empty($request->customer_type) && is_numeric($request->customer_type)) {
            $contact_numbers = Customer::where('customer_type', $request->customer_type)
                ->where('status', 1)
                ->whereNotNull('phone')
                ->pluck('phone')
                ->toArray();
        } elseif (!empty($request->customer_type) && $request->customer_type === "resellers") {
            $contact_numbers = Reseller::where('status', 1)
                ->whereNotNull('phone')
                ->pluck('phone')
                ->toArray();
        } elseif (!empty($request->numbers)) {
            $contact_numbers = explode(',', $request->numbers);
        } else {
            $contact_numbers = [];
        }
        $contact_array = [];
        foreach ($contact_numbers as $number) {
            if (substr($number, 0, 1) == '+') {
                $number = trim($number, '+');
            }
            if (strlen($number) == 11 && substr($number, 0, 1) == '0') {
                // Convert from '017XXXXXXXX' to '88017XXXXXXXX'
                $number = '880' . substr($number, 1);
            }
            if (strlen($number) != 13) {
                return response()->json([
                    "status" => "FAIL",
                    "message" => "Invalid number: $number",
                    "sub_message" => "Number length is: " . strlen($number),
                ]);
            }

            $contact_array[] = $number;
        }
        $job_batches = [];


        foreach (array_chunk($contact_array, 500) as $chunk) {
            $job_batches[] = new SendSmsJob($chunk, $request->message);
        }
        Bus::batch($job_batches)->dispatch();


        DB::beginTransaction();
        try {
            $records = new SmsCampaignRecord();
            $records->subject = $request->subject ?? '';
            $records->total = count($contact_array);
            $records->save();

            $sms_number_records = [];

            foreach ($contact_array as $number) {
                $sms_number_records[] = [
                    'sms_campaign_id' => $records->id,
                    'customer_phone' => $number,
                    'created_at' => now(),
                    'updated_at' => now()
                ];
            }
            SmsNumberRecord::insert($sms_number_records);

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                "status" => false,
                "message" => $th->getMessage(),
            ]);
        }

        return response()->json([
            "status" => true,
            "message" => "SMS is sending",
        ]);
    }
}
