<?php

namespace App\Http\Controllers\Admin;

use App\Models\OrderSource;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class OrderSourceController extends Controller
{
    public function index()
    {
        $source = OrderSource::orderBy('id', 'desc')->paginate(50);
        return response()->json([
            'status' => true,
            'sources' => $source
        ]);
    }



    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:order_sources',
        ]);

        $source = new OrderSource();
        $source->name = $request->name;
        $source->save();
        return response()->json([
            'status' => true,
            'message' => "source add successfully"
        ]);
    }


    public function edit($id)
    {
        $source = OrderSource::findOrFail($id);
        return response()->json([
            'status' => true,
            'source' => $source
        ]);
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $source = OrderSource::findOrFail($id);
        $source->name = $request->name;
        $source->save();
        return response()->json([
            'status' => true,
            'message' => " Updated successfully"
        ]);
    }



    public function status($id)
    {
        $source = OrderSource::findOrFail($id);
        if($source->status == 1){
            $source->status = 0;
        }else{
            $source->status = 1;
        }
        $source->save();
        return response()->json([
            'status' => true,
            'message' => 'Status Updated'
        ]);
    }


    public function setDefault($id)
    {
        $source = OrderSource::findOrFail($id);
        $source->activate();
        return response()->json([
            'status' => true,
            'message' => 'Set Default',
        ]);
    }


    public function activeSource()
    {
        $sources = OrderSource::where('status',1)->get();
        return response()->json([
            'status' => true,
            'sources' => $sources,
        ]);
    }


}
