<?php

namespace App\Http\Controllers\Admin;

use App\Models\City;
use App\Models\Comment;
use App\Models\Contact;
use App\Models\Courier;
use App\Models\Variant;
use App\Models\Category;
use App\Models\Merchant;
use App\Models\Supplier;
use App\Models\Attribute;
use App\Models\Subscriber;
use App\Models\SubCategory;
use Illuminate\Http\Request;
use App\Enums\CustomerStatus;
use App\Models\DeliveryCharge;
use App\Models\SubSubCategory;
use App\Services\HelperService;
use App\Models\RedxDeliveryArea;
use App\Exports\SubscribersExport;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Maatwebsite\Excel\Facades\Excel;
use Psy\CodeCleaner\FunctionReturnInWriteContextPass;

class OthersController extends Controller
{
    public function others(Request $request)
    {

        $categories = Category::where('status', 1)->get();
        $suppliers = Supplier::where('status', 1)->get();

        if (!empty($request->type)) {
            $suppliers = Supplier::where('status', 1)->where('type', $request->type)->get();
        }
        $attributes = Attribute::where('status', 1)->get();
        $variants = Variant::where('status', 1)->get();
        $subcategories = SubCategory::where('status', 1)->get();
        $SubSubcategories = SubSubCategory::where('status', 1)->get();
        $cities = City::where('status', 1)->orderBy('name')->get();
        $couriers = Courier::where('status', 1)->get();
        $comments = Comment::all();
        $merchants = Merchant::where('status', 1)->get();
        $redx_delivery_areas = RedxDeliveryArea::where('status', 1)->get();

        return response()->json([
            'status' => 'SUCCESS',
            'categories' => $categories,
            'subCategories' => $subcategories,
            'subSubCategories' => $SubSubcategories,
            'suppliers' => $suppliers,
            'attributes' => $attributes,
            'variants' => $variants,
            'cities' => $cities,
            'couriers' => $couriers,
            'comments' => $comments,
            'merchants' => $merchants,
            'redx_delivery_area' => $redx_delivery_areas,
        ]);
    }



    public function requestedTableData(Request $request)
    {

        $data = DB::table($request->table)->where('status', 1)->get();
        return response()->json([
            'success' => true,
            'data' => $data,
        ], 201);
    }






    public  function export_subscriber()
    {

        return Excel::download(new SubscribersExport(), 'subscribers.xlsx');
    }

    public function contact_message(Request $request)
    {
        $contacts = Contact::orderBy('id', 'desc')->paginate(50);
        return response()->json([
            'status'  => 'OK',
            'contacts' => $contacts,
        ]);
    }


    public function get_contacted_customer($id)
    {

        $customer = Contact::findOrFail($id);
        return response()->json(['customer' => $customer]);
    }



    public function search_contacted_customer($data)
    {
        $contacts = Contact::where('email', 'like', '%' . $data . '%')->orWhere('name', 'like', '%' . $data . '%')->orWhere('phone', 'like', '%' . $data . '%')->orderBy('id', 'desc')->paginate(50);
        return response()->json([
            "contacts" => $contacts,
        ]);
    }


    public function deliveryCharge()
    {
        $deliveries = DeliveryCharge::all();
        return response()->json([
            "status" => "SUCCESS",
            "deliveries" => $deliveries,
        ]);
    }

    public function editDeliveryCharge($id)
    {
        $delivery = DeliveryCharge::findOrFail($id);
        return response()->json([
            "status" => "SUCCESS",
            "delivery" => $delivery,
        ]);
    }

    public function updateDeliveryCharge(Request $request, $id)
    {
        $delivery = DeliveryCharge::findOrFail($id);
        $delivery->name = $request->name;
        $delivery->delivery_charge = $request->delivery_charge;
        $delivery->save();
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'delivery charge updated successfully'
        ]);
    }

    public function verifyConfig(Request $request)
    {
        $pass = $request->input('form_pass');

        $site = Http::get('https://mohasagorit.solutions/get/config/info');

        if ($site['status'] == true) {
            if ($site['config']['site_config_pass'] == $pass) {
                return response()->json(['status' => true]);
            }
        }
        return response()->json(['status' => false]);
    }



    public function getCustomerStatuses()
    {
        $statuses = array_map(fn($status) => [
            'value' => $status->value,
            'label' => $status->label()
        ], CustomerStatus::cases());

        return response()->json($statuses);
    }


    public function deleteCustomerMessage($id)
    {
        Contact::find($id)->delete();
        return sendResponseWithMessage(true, 'Deleted Successfully');
    }


    public function updateDeliveryChargeStatus($id)
    {
        $category = DeliveryCharge::find($id);
        if ($category->status == 1) {
            $category->status = 0;
        } else {
            $category->status = 1;
        }
        $category->save();
        return sendResponseWithMessage(true, 'Status Updated');
    }



    public function cityWiseRedxZone($id)
    {
        $redx_delivery_areas = RedxDeliveryArea::where('city_id', $id)->get();
        return response()->json([
            'status'              => true,
            'redx_delivery_areas' => $redx_delivery_areas,
        ]);
    }



    public function getRememberToken()
    {
        $rememberToken =  HelperService::siteRememberToken();
        $getSiteToken = request()->getHost();
        if (substr($getSiteToken, 0, 4) == 'www.') {
            $getSiteToken  = substr($getSiteToken, 4);
        }
        $siteToken = hash('sha256', $getSiteToken);

        if ($rememberToken == $siteToken) {

            return response()->json([
                'status' => true,
                'rememberToken' => '1111',
            ]);
        } else {
            return response()->json([
                'status' => false,
                'rememberToken' => '0000',
            ]);
        }
    }
}
