<?php

namespace App\Http\Controllers\Admin;

use App\Models\Page;
use App\Models\AboutAndContact;
use App\Models\OrderShipmentAndReturnPolicy;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class PageInfoController extends Controller
{



    public function index()
    {

        $pages = Page::orderBy('id', 'desc')->get();
        return response()->json([
            'status' => 'SUCCESS',
            'pages' => $pages
        ]);
    }



    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|unique:pages',
            'details' => 'required',
        ]);

        $page = new Page();
        $page->name = $request->name;
        $page->slug = Str::slug($request->name);
        $page->details = $request->details;
        $page->save();

        return response()->json([
            'status' => 'SUCCESS',
            'message' => "page added successfully"
        ]);
    }





    public function edit($id)
    {

        $page = Page::findOrFail($id);
        return response()->json([
            'status' => 'SUCCESS',
            'page' => $page
        ]);
    }




    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name' => 'required|unique:pages,name,' . $id,
            'details' => 'required',
        ]);

        $page = Page::findOrFail($id);
        $page->name = $request->name;
        $page->slug = Str::slug($request->name);
        $page->details = $request->details;
        $page->save();

        return response()->json([
            'status' => 'SUCCESS',
            'message' => "page updated successfully"
        ]);
    }

    public function deActivePage($id)
    {
        $page = Page::findOrFail($id);
        if ($page) {
            $page->status = 0;
            if ($page->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'page de-active successfully'
                ]);
            }
        }
    }

    public function activePage($id)
    {
        $page = Page::findOrFail($id);
        if ($page) {
            $page->status = 1;
            if ($page->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'page active successfully'
                ]);
            }
        }
    }


    public function deletePage($id)
    {
        $page = Page::find($id);
        if ($page) {
            if ($page->delete()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'page deleted successfully'
                ]);
            }
        }
    }


    public function get_about_and_contact_info()
    {

        $setting = AboutAndContact::latest()->take(1)->first();
        if ($setting) {
            return response()->json([
                "status" => "OK",
                "setting" => $setting,
            ]);
        }
    }



    public function edit_about_and_contact_info(Request $request, $id)
    {

        $setting = AboutAndContact::findOrFail($id);
        $setting->about_info = $request->about_info;
        $setting->contact_info = $request->contact_info;


        if ($setting->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'About and contact information updated successfully',
            ]);
        }
    }




    public function get_order_shipment_return_info()
    {

        $setting = OrderShipmentAndReturnPolicy::latest()->take(1)->first();
        if ($setting) {
            return response()->json([
                "status" => "OK",
                "setting" => $setting,
            ]);
        }
    }



    public function edit_order_shipment_return_info(Request $request, $id)
    {

        $setting = OrderShipmentAndReturnPolicy::findOrFail($id);
        $setting->order_info = $request->order_info;
        $setting->shipment_info = $request->shipment_info;
        $setting->return_policy = $request->return_policy;

        if ($setting->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Order,shipment and return information updated successfully',
            ]);
        }
    }

    public function cleanDB()
    {
        $backupFileName = 'db_backup_' . now()->format('Y-m-d_H-i-s') . '.sql';
        $backupFilePath = storage_path("app/{$backupFileName}");

        $dbHost = env('DB_HOST', '127.0.0.1');
        $dbPort = env('DB_PORT', '3306');
        $dbUser = env('DB_USERNAME', 'root');
        $dbPass = env('DB_PASSWORD', '');
        $dbName = env('DB_DATABASE', 'your_database_name');

        try {
            // Run MySQL dump command to create a backup
            $command = "mysqldump --user={$dbUser} --password={$dbPass} --host={$dbHost} --port={$dbPort} {$dbName} > {$backupFilePath}";
            exec($command);

            if (!file_exists($backupFilePath)) {
                throw new \Exception("Database backup failed!");
            }

            DB::statement('SET FOREIGN_KEY_CHECKS=0;');

            $tables = [
                'aamarpay_configurations',
                'about_and_contacts',
                'balance_transfers',
                'banners',
                'bill_paid_statements',
                'bill_per_months',
                'bkash_configurations',
                'book_attachments_imgs',
                'campaigns',
                'campaign_products',
                'campaign_sliders',
                'combo_products',
                'companies',
                'company_assets',
                'company_sale_paids',
                'contacts',
                'coupons',
                'courier_apis',
                'credits',
                'credit_dues',
                'customers',
                'customer_reviews',
                'debits',
                'directors',
                'director_payments',
                'director_refunds',
                'employees',
                'employee_salaries',
                'fond_transfers',
                'investments',
                'investment_returns',
                'investors',
                'investor_profit_paids',
                'loaners',
                'loans',
                'loan_paids',
                'orders',
                'orders_payment',
                'order_barcodes',
                'order_comments',
                'order_items',
                'order_item_variants',
                'order_notes',
                'order_shipment_and_return_policies',
                'otp_verifications',
                'product_barcodes',
                'password_resets',
                'products',
                'product_images',
                'product_reviews',
                'product_variants',
                'product_visits',
                'purchases',
                'purchase_items',
                'salary_per_months',
                'sales',
                'sale_items',
                'sliders',
                'categories',
                'brands',
                'sub_categories',
                'sub_sub_categories',
                'suppliers',
                'supplier_payments',
                'users',
                'landing_pages',
                'descriptions',
                'resellers',
                'reseller_balance',
                'reseller_cashbooks',
                'reseller_cashbook_payment_transaction_details',
                'reseller_categories',
                'reseller_order_details',
                'reseller_payments',
                'reseller_payment_methods',
                'reseller_payment_transactions',
                'reseller_product_prices',
                'reseller_sliders'
            ];

            // Truncate all tables
            foreach ($tables as $table) {
                DB::table($table)->truncate();
            }

            // Re-enable foreign key checks
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
            return response()->json([
                'status' => true,
                'message' => 'Database backup saved to : ' . $backupFilePath . ' before Tables are truncated!',
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => "Error: " . $e->getMessage(),
            ]);
        }
    }
}
