<?php

namespace App\Http\Controllers\Admin;

use App\Models\Product;
use App\Models\LandingPage;
use Illuminate\Http\Request;
use App\Models\ProductReview;
use App\Http\Controllers\Controller;

class ProductReviewController extends Controller
{

      public function get_customer_review()
      {

            $reviews = ProductReview::latest()->with('review_product', 'reviewer')->paginate(20);
            return response()->json([
                  "status" => "OK",
                  "reviews" => $reviews,
            ]);
      }




      public function deactive_customer_review($id)
      {

            $review = ProductReview::findOrFail($id);
            $review->status = 0;
            $review->save();
            return response()->json([
                  "status" => "OK",
                  "message" => 'review de-activated',
            ]);
      }



      public function active_customer_review($id)
      {

            $review = ProductReview::findOrFail($id);
            $review->status = 1;
            $review->save();



            $product_reviews = ProductReview::where('product_id', $review->product_id)->where('status', 1)->orderBy('rating_stars', 'desc')->get();     
            $product_reviews_count = ProductReview::where('product_id', $review->product_id)->where('status', 1)->count();
            $rating_stars = array();
            $rating_stars['five_star'] = $product_reviews->where('rating_stars', 5)->count();
            $rating_stars['four_star'] = $product_reviews->where('rating_stars', 4)->count();
            $rating_stars['three_star'] = $product_reviews->where('rating_stars', 3)->count();
            $rating_stars['two_star'] = $product_reviews->where('rating_stars', 2)->count();
            $rating_stars['one_star'] = $product_reviews->where('rating_stars', 1)->count();  
            
            $total_review_with_star = (($rating_stars['five_star'] * 5 ) + ($rating_stars['four_star'] * 4 ) + ($rating_stars['three_star'] * 3 ) + ($rating_stars['two_star'] * 2 ) + ($rating_stars['one_star'] * 1 ));
            $avg_review_star = (number_format($total_review_with_star / $product_reviews_count, 1));

            $product = Product::findOrFail($review->product_id);
            $product->avg_review = $avg_review_star;
            $product->review_ratings = $product_reviews_count;
            $product->save();

            
            return response()->json([
                  "status" => "OK",
                  "message" => 'review activated',
            ]);
      }


      public function remove_customer_review($id)
      {

            $review = ProductReview::findOrFail($id);
            $review->delete();
            return response()->json([
                  "status" => "OK",
                  "message" => 'review deleted',
            ]);
      }
      public function addReview(Request $request)
      {
       
            $review = new ProductReview();
            $review->status = 1;
            if ($request->hasFile('image')) {
                  $path = $request->file('image')->store('images/review', 'public');
                  $review->image = $path; // Save image path to the database
            } else {
                  return response()->json([
                        'success' => false,
                        'message' => 'Image is required',
                  ], 400);
            }
            $review->save();

            return response()->json([
                  'success' => true,
                  'message' => 'Review added successfully'
            ]);
      }

      //  public function addReview(Request $request)
      //  {
      //       return $request->all();
      //       $this->validate($request, [
      //             'user_name' => 'required',
      //             'landing_page_id' => 'required',
      //             'review' => 'required',
      //             'rating_stars' => 'required',
      //       ]);
      //       $review = new ProductReview();
      //       $review->landing_page_id = $request->landing_page_id;
      //       $review->user_name = $request->user_name;
      //       $review->review = $request->review;
      //       $review->rating_stars = $request->rating_stars;
      //       $review->status = 1;
      //       if ($request->hasFile('image')) {
      //             $path = $request->file('image')->store('images/review', 'public');
      //             $review->image = $path;
      //       }
      //       $review->save();
      //       return response()->json([
      //             'success' => true,
      //             'message' => 'review added successfully'
      //       ]);
      //  }

      public function landingPageReview($slug)
      {
            $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
            $reviews = ProductReview::where('landing_page_id', $page->id)->with('landingPage')->get();
            return response()->json([
                  'success' => true,
                  'reviews' => $reviews,
            ]);
      }


      public function landingPageReviewEdit($id)
      {
            $review = ProductReview::with('landingPage')->find($id);
            return response()->json([
                  'success' => true,
                  'review' => $review
            ]);
      }



      public function landingPageReviewUpdate(Request $request, $id)
      {
            $this->validate($request, [
                  'user_name' => 'required',
                  'landing_page_id' => 'required',
                  'review' => 'required',
                  'rating_stars' => 'required',
            ]);
            $review = ProductReview::with('landingPage')->find($id);
            $review->landing_page_id = $request->landing_page_id;
            $review->user_name = $request->user_name;
            $review->review = $request->review;
            $review->rating_stars = $request->rating_stars;
            if ($request->hasFile('image')) {
                  $path = $request->file('image')->store('images/review', 'public');
                  $review->image = $path;
            }
            $review->save();
            return response()->json([
                  'success' => true,
                  'message' => 'review added successfully'
            ]);
      }
}
