<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Publisher;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PublisherController extends Controller
{
    public function index()
  {
      $publishers = Publisher::orderby('id', 'desc')->paginate(10);
      return response()->json([
          'status' =>  true,
          'publishers' => $publishers,
      ]);   
  }

  public function store(Request $request)
  {

      $this->validate($request, [
          'name' => 'required|unique:publishers',
          'meta_title' => 'nullable|max:70',
          'meta_key' => 'nullable',
          'meta_description' => 'nullable|max:170',
          'meta_content' => 'nullable',
      ]);
      $slug = explode(" ", $request->name);
      $publisher = new Publisher();
      $publisher->name = $request->name;
      $publisher->slug = Str::slug($publisher->name);
      $publisher->status = 1;
      $publisher->meta_title = $request->meta_title;
      $publisher->meta_description = $request->meta_description;
      $publisher->meta_key = $request->meta_key;
      $publisher->meta_content = $request->meta_content;

      if ($request->hasFile('image')) {
          $validatedData = $request->validate([
              //'image' => 'required|file|image|dimensions:max_width=1000,max_height=1000',
          ]);
          // $path = $request->file('image')->store('images/publisher', 'public');
          $path = $request->file('image')->store('images/publisher', 'public');
          $publisher->image = $path;
      }
      if ($publisher->save()) {
          return response()->json([
              'status' => 'SUCCESS',
              'message' => 'publisher added successfully'
          ]);
      }
  }

  public function active($id)
  {
      $publisher = Publisher::find($id);
      if ($publisher) {
          $publisher->status = 1;
          if ($publisher->save()) {
              return response()->json([
                  'status' => true,
                  'message' => 'publisher actived successfully'
              ]);
          }
      }
  }

  public function deActive($id)
  {
      $publisher = Publisher::find($id);
      if ($publisher) {
          $publisher->status = 0;
          if ($publisher->save()) {
              return response()->json([
                  'status' => true,
                  'message' => 'publisher de-actived successfully'
              ]);
          }
      }
  }

  public function edit($id)
  {
      $publisher = Publisher::find($id);
      if ($publisher) {
          return response()->json([
              'status' => 'SUCCESS',
              'publisher' => $publisher
          ]);
      }
  }

  public function update(Request $request, $id)
  {

      $this->validate($request, [
          'name' => 'required|unique:publishers,name,' .$id,
          // 'description' => 'required|unique:publishers',
          'meta_title' => 'nullable|max:70',
          'meta_key' => 'nullable',
          'meta_description' => 'nullable|max:170',
          'meta_content' => 'nullable',
      ]);
      // $slug = explode(" ", $request->name);
      $publisher = Publisher::find($id);;
      $publisher->name = $request->name;
      $publisher->slug = Str::slug($publisher->name);
      $publisher->status = 1;
      $publisher->meta_title = $request->meta_title;
      $publisher->meta_description = $request->meta_description;
      $publisher->meta_key = $request->meta_key;
      $publisher->meta_content = $request->meta_content;

      if ($request->hasFile('image')) {
          // $validatedData = $request->validate([]);
          $path = $request->file('image')->store('images/publisher', 'public');
          $publisher->image = $path;
      }
      if ($publisher->save()) {
          return response()->json([
              'status' => 'SUCCESS',
              'message' => 'publisher updated successfully'
          ]);
      }
  }

  public function search($search)
  {
      $publishers = Publisher::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

      if ($publishers) {
          return response()->json([
              'publishers' => $publishers,
              'status' => true
          ]);
      }
  }

  public function getPublisherName()
  {
      $publishers = Publisher::where('status', 1)->get();
      return response()->json([
          'success' => true,
          'publishers' => $publishers,
      ]);
  }
}
