<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use App\Models\Sale;
use App\Models\Debit;
use App\Models\Order;
use App\Models\Credit;
use App\Models\Damage;
use App\Models\Purchase;
use App\Models\SaleItem;
use App\Models\Supplier;
use App\Models\OrderItem;
use App\Models\PurchaseItem;
use Illuminate\Http\Request;
use App\Models\BillStatement;
use App\Models\AccountPurpose;
use App\Models\SupplierPayment;
use Barryvdh\DomPDF\Facade as PDF;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class ReportController extends Controller
{

  public function __construct()
  {
    $this->middleware('admin');
  }

  public function orderReport(Request $request)
  {

    $item = $request->item ?? 10;
    if (!empty($request->start_date) && empty($request->end_date)) {
      $orders = Order::where('created_at', '=', $request->start_date)
        ->orderBy('id', 'DESC')
        ->with('orderItem')
        ->paginate($item);
    } elseif (!empty($request->start_date) && !empty($request->end_date)) {
      $orders = Order::where('created_at', '>=', $request->start_date)
        ->where('created_at', '<=', $request->end_date)
        ->orderBy('id', 'DESC')
        ->with('orderItem')
        ->paginate($item);
    } else {
      $orders = Order::orderBy('id', 'DESC')->with('orderItem')->paginate($item);
    }


    return \response()->json($orders);
  }

  public function officeSaleReport(Request $request)
  {


    $item = $request->item ?? 10;

    if (!empty($request->start_date) && empty($request->end_date)) {
      $sales = Sale::where('created_at', '=', $request->start_date)
        ->orderBy('id', 'DESC')
        ->with('saleItems')
        ->where('status', 1)
        ->paginate($item);
    } elseif (!empty($request->start_date) && !empty($request->end_date)) {
      $sales = Sale::where('created_at', '>=', $request->start_date)
        ->where('created_at', '<=', $request->end_date)
        ->orderBy('id', 'DESC')
        ->with('saleItems')
        ->where('status', 1)
        ->paginate($item);
    } else {
      $sales = Sale::orderBy('id', 'DESC')->with('saleItems')->where('status', 1)->paginate($item);
    }

    return \response()->json($sales);
  }

  public function accountReport(Request $request)
  {

    $account = array();
    $account['credit'] = 0;
    $account['debit'] = 0;

    if (empty($request->start_date) && empty($request->end_date)) {
      $credit = Credit::all();
      $debit = Debit::all();
    }

    if (!empty($request->start_date) && empty($request->end_date)) {
      $credit = Credit::whereDate('date', '=', $request->start_date)->get();
      $debit = Debit::whereDate('date', '=', $request->start_date)->get();
    }
    if (!empty($request->start_date) && !empty($request->end_date)) {
      $credit = Credit::whereDate('date', '>=', $request->start_date)->whereDate('date', '<=', $request->end_date)->get();
      $debit = Debit::whereDate('date', '>=', $request->start_date)->whereDate('date', '<=', $request->end_date)->get();
    }

    $account['credit'] = $credit->sum('amount');
    $account['debit'] = $debit->sum('amount');

    return \response()->json($account);
  }

  public function purchaseReport(Request $request)
  {

    $item = $request->item ?? 10;

    if (!empty($request->start_date) && empty($request->end_date)) {
      $purchase = Purchase::where('created_at', '=', $request->start_date)
        ->orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->paginate($item);
    } elseif (!empty($request->start_date) && !empty($request->end_date)) {
      //return $request->all();
      $purchase = Purchase::where('created_at', '>=', $request->start_date)
        ->where('created_at', '<=', $request->end_date)
        ->orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->paginate($item);
    } elseif (empty($request->start_date) && !empty($request->end_date)) {

      $purchase = Purchase::where('created_at', '=', $request->end_date)
        ->orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->paginate($item);
    } else {
      $purchase = Purchase::orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->paginate($item);
    }

    return \response()->json($purchase);
  }





  public function supplierReport()
  {
    $supplier_id = Purchase::select('supplier_id')->pluck('supplier_id')->unique();

    $suppliers = Supplier::whereIn('id', $supplier_id)->get();

    $data = [];

    foreach ($suppliers as $k => $supplier) {

      $data[$supplier->company_name] = [
        'total_purchase_amount' => Purchase::where('supplier_id', $supplier->id)->sum('total'),
        'total_paid_amount' => SupplierPayment::where('supplier_id', $supplier->id)->sum('amount'),
        'purchase_count' => Purchase::where('supplier_id', $supplier->id)->count()
      ];
    }
    return \response()->json($data);
  }










  public function office_sale_report_pdf($start_date, $end_date)
  {

    if ($start_date == "All" && $end_date == "All") {
      $sales = Sale::orderBy('id', 'DESC')->with('saleItems')->get();
    }

    if ($start_date != "All" && $end_date == "All") {
      $sales = Sale::where('created_at', '=', $start_date)
        ->orderBy('id', 'DESC')
        ->with('saleItems')
        ->where('status', 1)
        ->get();
    }

    if ($start_date == "All" && $end_date != "All") {
      $sales = Sale::where('created_at', '=', $start_date)
        ->orderBy('id', 'DESC')
        ->with('saleItems')
        ->where('status', 1)
        ->get();
    }

    if ($start_date != 'All' && $end_date != "All") {
      $sales = Sale::where('created_at', '>=', $start_date)
        ->where('created_at', '<=', $end_date)
        ->orderBy('id', 'DESC')
        ->with('saleItems')
        ->where('status', 1)
        ->get();
    }

    $pdf = PDF::loadView('admin.pdf.office_sale_report', compact('sales'));
    return $pdf->stream();
  }



  public function order_sale_report_pdf($start_date, $end_date)
  {

    if ($start_date == "All" && $end_date == "All") {
      $orders = Order::orderBy('id', 'DESC')->with('orderItem')->get();
    }

    if ($start_date != "All" && $end_date == "All") {
      $orders = Order::where('created_at', '=', $start_date)
        ->orderBy('id', 'DESC')
        ->with('orderItem')
        ->get();
    }

    if ($start_date == "All" && $end_date != "All") {
      $orders = Order::where('created_at', '=', $end_date)
        ->orderBy('id', 'DESC')
        ->with('orderItem')
        ->get();
    }

    if ($start_date != 'All' && $end_date != "All") {
      $orders = Order::where('created_at', '>=', $start_date)
        ->where('created_at', '<=', $end_date)
        ->orderBy('id', 'DESC')
        ->with('orderItem')
        ->get();
    }

    $pdf = PDF::loadView('admin.pdf.order_sale_report', compact('orders'));
    return $pdf->stream();
  }



  public function purchase_report_pdf($start_date, $end_date)
  {

    if ($start_date == "All" && $end_date == "All") {
      $purchases = Purchase::orderBy('id', 'DESC')->with(['purchaseItems', 'supplier'])->get();
    }

    if ($start_date != "All" && $end_date == "All") {
      $purchases = Purchase::where('created_at', '=', $start_date)
        ->orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->get();
    }

    if ($start_date == "All" && $end_date != "All") {
      $purchases = Purchase::where('created_at', '=', $end_date)
        ->orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->get();
    }

    if ($start_date != 'All' && $end_date != "All") {
      $purchases = Purchase::where('created_at', '>=', $start_date)
        ->where('created_at', '<=', $end_date)
        ->orderBy('id', 'DESC')
        ->with(['purchaseItems', 'supplier'])
        ->get();
    }

    $pdf = PDF::loadView('admin.pdf.purchase_report', compact('purchases'));
    return $pdf->stream();
  }

  public function saleProfite(Request $request)
  {


    //  return $request->all();

    $sale_items = SaleItem::orderBy('id', 'DESC')->where('status', 1)->groupBy('sale_id');

    if (!empty($request->start_date) && empty($request->end_date)) {
      $sale_items = SaleItem::whereDate('created_at', '=', $request->start_date)
        ->orderBy('id', 'DESC')
        ->where('status', 1)
        ->get()
        ->groupBy('sale_id');
    }
    if (!empty($request->start_date) && !empty($request->end_date)) {
      $sale_items = SaleItem::whereDate('created_at', '>=', $request->start_date)
        ->whereDate('created_at', '<=', $request->end_date)
        ->orderBy('id', 'DESC')->where('status', 1)
        ->get()
        ->groupBy('sale_id');
    }



    $data = [];

    $i = 0;
    foreach ($sale_items as $k => $sale_item) {

      //  return $sale_item;
      $i++;
      $purchase_total = 0;
      $a_price = 0;

      foreach ($sale_item as $item) {
        $product_purchase_items = PurchaseItem::where('product_id', $item->product_id)->get();
        $purchase_price = 0;
        foreach ($product_purchase_items as $product_purchase_item) {
          $purchase_price += $product_purchase_item->price * $product_purchase_item->stock;
        }
        if ($purchase_price > 0) {
          $a_price = $purchase_price / $product_purchase_items->sum('stock');
          $purchase_total += $a_price * $item->qty;
        }
      }
      $sale = Sale::where('id', $k)->where('status', 1)->first();
      $s_total = 0;
      $s_discount = 0;

      if (!empty($sale->total)) {
        $s_total = $sale->total;
      }
      if (!empty($sale->discount)) {
        $s_discount = $sale->discount;
      }
      $data[$i] = [
        'sale_invoice' => $k,
        'sale_total' => $s_total - $s_discount,
        'product_purchase_amount' => $purchase_total,
        'product_count' => $sale_item->sum('qty')
      ];
    }
    return \response()->json($data);
  }




  public function orderProfit(Request $request)
  {

    $order_items = OrderItem::where('status', 1)->get()->groupBy('order_id');
    if (!empty($request->start_date) && empty($request->end_date)) {
      $order_items = OrderItem::where('status', 1)->whereDate('created_at', '=', $request->start_date)->get()->groupBy('order_id');
    }

    if (!empty($request->start_date) && !empty($request->end_date)) {
      $order_items = OrderItem::where('status', 1)->whereDate('created_at', '>=', $request->start_date)
        ->whereDate('created_at', '<=', $request->end_date)
        ->get()
        ->groupBy('order_id');
    }

    $data = [];
    $i = 0;
    foreach ($order_items as $k => $order_item) {
      $i++;
      $purchase_total = 0;
      $a_price = 0;

      foreach ($order_item as $item) {
        if ($item->purchase_price > 0) {
          $purchase_total += $item->purchase_price * $item->quantity;
        } else {
          $product_purchase_items = PurchaseItem::where('product_id', $item->product_id)->get();
          $purchase_price = 0;
          foreach ($product_purchase_items as $product_purchase_item) {
            $purchase_price += $product_purchase_item->price * $product_purchase_item->stock;
          }
          if ($purchase_price > 0) {
            $a_price = $purchase_price / $product_purchase_items->sum('stock');
          }
          $purchase_total += $a_price * $item->quantity;
        }
      }
      $order = Order::where('id', $k)->first();

      if (!empty($order) && $order->status == 5) {
        $data[$i] = [
          'order_invoice' => $order->invoice_no,
          'order_total' => $order->total - $order->discount,
          'product_purchase_amount' => $purchase_total,
          'product_count' => $order_item->sum('quantity'),
          'order_date' => date("d-m-Y", strtotime($order->created_at)),
          'order_delivered_date' => date("d-m-Y", strtotime($order->delivery_date)) ?? ""
        ];
      }
    }
    return $data;
  }





  public function  profitReport(Request  $request)
  {
    if (!empty($request->start_date)  &&  !empty($request->end_date)) {

      $actual_expense = Debit::where('is_expense', 1)->where('is_fund_transfer', 0)->whereDate('created_at', '>=', $request->start_date)->whereDate('created_at', '<=', $request->end_date)->sum('amount');

      $other_expense = Debit::where('is_expense', 0)->where('is_fund_transfer', 0)->whereDate('created_at', '>=', $request->start_date)->whereDate('created_at', '<=', $request->end_date)->sum('amount');

      $debit_purposes = AccountPurpose::select('id', 'text', 'is_expense')->get();

      foreach ($debit_purposes as $key => $item) {
        $item->{'amount'} = DB::table('debits')->where('is_fund_transfer', 0)->whereDate('created_at', '>=', $request->start_date)->whereDate('created_at', '<=', $request->end_date)->where('purpose', $item->id)->sum('amount');
      }

      //bill statement details 
      $bills = BillStatement::where('status', 1)->select('id', 'name')->get();

      foreach ($bills as $bill) {
        $bill->{'amount'} = DB::table('debits')->whereDate('created_at', '>=', $request->start_date)->whereDate('created_at', '<=', $request->end_date)->where('comment', 'like', '%' . $bill->name . '%')->sum('amount');
      };

      //office sales
      $sales = Sale::where('sale_type', 1)->select('id', 'total', 'discount')->whereDate('created_at', '>=', $request->start_date)->whereDate('created_at', '<=', $request->end_date)->with(['saleItems:id,sale_id,qty,product_id,variant_id,purchase_price'])->orderBy('id', 'desc')->get();


      $total_sales_amount = $sales->sum('total') - $sales->sum('discount');


      // total sales purchase amount
      $total_sales_purchase_amount = 0;

      foreach ($sales as $key => $sale) {
        foreach ($sale->saleItems as $item) {
          $total_sales_purchase_amount += $item->purchase_price * $item->qty;
        }
      }


      //company sales
      $company_sales = Sale::where('sale_type', 2)->select('id', 'total', 'discount')->whereDate('created_at', '>=', $request->start_date)->whereDate('created_at', '<=', $request->end_date)->with(['saleItems:id,sale_id,qty,product_id,variant_id,purchase_price'])->orderBy('id', 'desc')->get();
      $total_company_sales_amount = $company_sales->sum('total') - $company_sales->sum('discount');
      // total sales purchase amount
      $total_company_sales_purchase_amount = 0;
      foreach ($company_sales as $key => $sale) {
        foreach ($sale->saleItems as $item) {
          $total_company_sales_purchase_amount += $item->purchase_price * $item->qty;
        }
      }


      //orders only delivered
      $orders = Order::where('status', 5)->select('id', 'total', 'shipping_cost', 'discount')->whereDate('delivery_date', '>=', $request->start_date)->whereDate('delivery_date', '<=', $request->end_date)->with(['orderItem:id,order_id,quantity,product_id,purchase_price,status,price'])->orderBy('id', 'desc')->get();
      // total orders purchase amount
      $total_orders_purchase_amount = 0;
      $total_orders_amount = 0;
      
      foreach ($orders as $key => $order) {
        foreach ($order->orderItem as $item) {
          $total_orders_purchase_amount += intval($item->purchase_price) *  intval($item->quantity);
          $total_orders_amount += intval($item->price) * intval($item->quantity);
        }
      }



      //damage report
      $damage_items = Damage::with('items.product')->where('status', 1)
        ->whereDate('created_at', '>=', $request->start_date)
        ->whereDate('created_at', '<=', $request->end_date)
        ->get();

      $totalDamageAmount = Damage::where('status', 1)
        ->whereDate('created_at', '>=', $request->start_date)
        ->whereDate('created_at', '<=', $request->end_date)
        ->sum('total_amount');

      return response()->json([
        'success'                      => true,
        'debit_purposes'               => $debit_purposes,
        'actual_expense'               => $actual_expense,
        'other_expense'                => $other_expense,
        'damage_items'                 => $damage_items,
        'totalDamageAmount'            => $totalDamageAmount,
        'bills'                        => $bills,
        'total_orders_amount'          => $total_orders_amount,
        'total_sales_amount'           => $total_sales_amount,
        'total_company_sales_amount'   => $total_company_sales_amount,
        'total_orders_purchase_amount' => $total_orders_purchase_amount,
        'total_sales_purchase_amount'  => $total_sales_purchase_amount,
        'total_company_sales_purchase_amount' =>  $total_company_sales_purchase_amount,
      ]);
    }
  }

  public function fetchFacebookAdInsights(Request $request)
  {
    $accessToken = 'EAA4jqUBJM4gBPBZCQQ7HyBlymaAP7RjxZBa8oDoXnNO07P4SwfYBbFV5tZCJvKoEnHmwfjOJBPvZC1ZAsCKVjdhqcXFnyiMT7ED3S2TCQfGF9DariBlj9J7sm4uZCSzQRCZCqm6u2OvE6COH5hKQ82OJIlAgZAjmgBlg4zE9YdQCoowpGVBCr6Yn8sfbLpGQgjgJ6wZDZD'; // Store it in .env
    $adAccountId = 'act_8368527409850485'; // e.g., act_12345678

    $url = "https://graph.facebook.com/v19.0/{$adAccountId}/insights";
    $params = [
      'fields' => 'campaign_id,campaign_name,adset_id,adset_name,ad_id,ad_name,spend,clicks,impressions,reach,cpm,cpc',
      'level' => 'ad',
      'date_preset' => 'last_30d',
      'access_token' => $accessToken
    ];

    $response = Http::get($url, $params);

    if ($response->failed()) {
      return response()->json(['error' => 'Failed to fetch ad insights'], 500);
    } 

    return response()->json($response->json());
  }
}
