<?php

namespace App\Http\Controllers\Admin;

use App\Models\Order;
use App\Models\Reseller;
use Illuminate\Http\Request;
use App\Models\ResellerPayments;
use App\Exports\ResellersExport ;
use App\Services\HelperService;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Comment;
use App\Models\Credit;
use App\Models\Debit;
use App\Services\SmsService;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel ;
use App\Models\ResellerCashbook;
use Carbon\Carbon;
use App\Models\ResellerComment;
class ResellerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getReseller(Request $request)
    {
        $item=$request->item??10;
        
        if (!empty($request->search)) {

            $resellers = Reseller::where('status', $request->status)->where('name', 'like', '%' . $request->search . '%')->orWhere('username', 'like', '%' . $request->search . '%')->orWhere('company_name', 'like', '%' . $request->search . '%')->orWhere('phone', 'like', '%' . $request->search . '%')->select('id','name','phone','email','username','refer_id','logo','company_name','last_login_date','total_sms','page_name','comment','status',DB::raw('DATE_FORMAT(created_at,"%d %b %Y") as create_time'))->orderBy('id','DESC')->paginate($item);
            $comments = Comment::all();
            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
                $income = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',1)->sum('amount');
                $expense = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',0)->sum('amount');
                $reseller->{'wallet_value'} = intval($income) - intval($expense);
            }
        } elseif($request->search == 2){

            $resellers = Reseller::select('id','name','phone','email','username','refer_id','logo','company_name','page_name','comment','last_login_date','total_sms','status',DB::raw('DATE_FORMAT(created_at,"%d %b %Y") as create_time'))->orderBy('id','DESC')->paginate($item);
            $comments = Comment::all();
            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
                $income = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',1)->sum('amount');
                $expense = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',0)->sum('amount');
                $reseller->{'wallet_value'} = intval($income) - intval($expense);
            }
        }elseif($request->search == 'payable'){

            $resellers = Reseller::select('id','name','phone','email','username','refer_id','logo','company_name','page_name','comment','last_login_date','total_sms','status',DB::raw('DATE_FORMAT(created_at,"%d %b %Y") as create_time'))->orderBy('id','DESC')->paginate($item);
            $comments = Comment::all();
            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
                $income = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',1)->sum('amount');
                $expense = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',0)->sum('amount');
                $reseller->{'wallet_value'} = intval($income) - intval($expense);
            }
        }else{

            $resellers = Reseller::where('status', $request->status)->select('id','name','phone','email','username','refer_id','logo','company_name','page_name','comment','last_login_date','total_sms','status',DB::raw('DATE_FORMAT(created_at,"%d %b %Y") as create_time'))->orderBy('id','DESC')->paginate($item);
            $comments = Comment::all();
            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
                $income = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',1)->sum('amount');
                $expense = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',0)->sum('amount');
                $reseller->{'wallet_value'} = intval($income) - intval($expense);
            }
        }


        return response()->json([
                "success" => "OK",
                "resellers" => $resellers  ,
                "comments" => $comments,
        ]);


     }


    public function resellerAmount(Request $request)
    {
        $item=$request->item??30;
        if(!empty($request->search)){
            $resellers = Reseller::where('status', $request->status)->where('name', 'like', '%' . $request->search . '%')->orWhere('username', 'like', '%' . $request->search . '%')->orWhere('company_name', 'like', '%' . $request->search . '%')->orWhere('phone', 'like', '%' . $request->search . '%')->select('id','name','phone','email','username','refer_id','logo','company_name','page_name','last_login_date','total_sms','comment','status')->orderBy('wallet_value','DESC')->paginate($item);
            
            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
                $income = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',1)->sum('amount');
                $expense = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',0)->sum('amount');
                $reseller->{'wallet_value'} = intval($income) - intval($expense);
            }
        }else{
            //status 0 = minus amount, 1 = positive amount
            if($request->status == 1){
                $resellers = Reseller::where('wallet_value', '>',0)->select('id','name','phone','email','username','refer_id','logo','company_name','page_name','comment','last_login_date','total_sms','status')->orderBy('wallet_value','DESC')->paginate($item);
            }else{
                $resellers = Reseller::where('wallet_value', '<',0)->select('id','name','phone','email','username','refer_id','logo','company_name','page_name','comment','last_login_date','total_sms','status')->orderBy('wallet_value','DESC')->paginate($item);
            }
            
            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
                $income = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',1)->sum('amount');
                $expense = ResellerCashbook::where('reseller_id',$reseller->id)->where('is_income',0)->sum('amount');
                $current_balance = intval($income) - intval($expense);
                $reseller->wallet_value = $current_balance;
                $reseller->save();
                $reseller->{'wallet_value'} = intval($income) - intval($expense);
            }
        }
        
        return response()->json([
            "success" => "OK",
            "resellers" => $resellers,
        ]);
    }



     public function resellerComment(Request $request)
    {
        $reseller = Reseller::where('id', $request->reseller_id)->first();
        $reseller->comment = $request->comment;
        $reseller->save();
        return response()->json([
            'status' => 'OK',
            'message' => $reseller->comment . '  is added as comment ',
        ]);
    }





    public function allReseller(Request $request)
    {
        if(!empty($request->search)) {
            $resellers = Reseller::where('status',1)->where('name','like','%'.$request->search.'%')->orWhere('phone','like','%'.$request->search.'%')->orderBy('name')->select('id','name','phone')->get();
        } else {
            $resellers = Reseller::where('status',1)->orderBy('name')->select('id','name','phone')->get();
        }

        return response()->json([
            "success" =>true,
            "resellers" => $resellers,
        ]);
        
     }




    public function addReseller(Request $request)
    {
        $data = $request->validate([
            'name'  => 'required',
            'company_name'  => 'required',
            'refer_id'  => 'nullable',
            'email'  => 'required|unique:resellers',
            'phone'  => 'required|unique:resellers|digits:11',
            // 'bkash_no'  => 'required|unique:resellers|digits:11',
            'address'  => 'required',
            // 'commission'  => 'required',
            // 'order_return_cost'  => 'required',
            'page_name'  => 'nullable',
        ]);
            //check refer id
            if (!empty($data['refer_id'])) {
                $is_exist = Reseller::where('username',$data['refer_id'])->first();
                if (empty($is_exist)) {
                return response()->json(
                    [
                        'status' => 'invalid_referred_id',
                        'message' => 'this refer id is not valid',
                    ]) ;
                }
            }
          $r_id = Reseller::max('id') + 001;
          $data['username'] = 'dropshipping'. $r_id ;
          $data['password'] = Hash::make(12345678);
          $data['status'] = 2;
          if ($request->hasFile('image')) {
           $file_path = $request->file('image')->store('images/reseller','public');
           $data['image']=$file_path ;
         }
         if ($request->hasFile('logo')) {
            $file_path = $request->file('logo')->store('images/reseller','public');
            $data['logo']=$file_path ;
          }
         $reseller = Reseller::query()->create($data);
         (new SmsService())->resellerLoginCredential($reseller,12345678);
         return response()->json([
           "success"  => "OK",
           "message"  => "Reseller added successfully"
        ]);


     }




    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $reseller  = Reseller::findOrFail($id);
        return response()->json([
            "success"  => "OK",
                "reseller"  => $reseller,
        ]);



    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         $reseller = Reseller::findOrFail($id);
         return response()->json([
             'reseller' => $reseller,
         ]);
    }


    public function reseller_search($data){

           $resellers = Reseller::where('username','like','%'.$data.'%')
                                  ->orWhere('email','like','%'.$data.'%')
                                  ->orWhere('phone','like','%'.$data.'%')
                                  ->paginate(10);

            foreach ($resellers as $reseller) {
                $reseller->{'total_order'} = Order::where('reseller_id',$reseller->id)->count();
            }
          return response()->json([
              "status" => "OK",
              'resellers' => $resellers ,
          ]);

    }



    public function updateReseller(Request $request, $id) {
        $reseller = Reseller::findOrFail($id);
        $data = $request->validate([
            'name' => 'required',
            'email' => 'required|unique:resellers,email,' . $id,
            'phone' => 'required|digits:11|unique:resellers,phone,' . $id,
            'address' => 'required',
            "company_name" => 'required',
            "company_phone" => 'nullable|digits:11|unique:resellers,company_phone,' . $id,
            "page_name" => 'nullable',
            "page_url" => 'nullable',
            "website_url" => 'nullable|unique:resellers,website_url,' . $id,
            "address" => 'nullable',
            "bank_name" => 'nullable',
            "bank_acc_name" => 'nullable',
            "bank_acc_number" => 'nullable',
            "bank_branch_name" => 'nullable',
            "bkash_no" => 'nullable',
            "nagod_no" => 'nullable',
            "rocket_no" => 'nullable',
            'refer_id'  => 'nullable',
            'commission'  => 'required',
            // 'order_return_cost'  => 'required',
            'cod_charge' => 'required',
            'total_sms' => 'nullable',
        ]);

        if ($request->hasFile('image')) {
            $file_path = $request->file('image')->store('images/reseller', 'public');
            $reseller->image = $file_path;
        }

        if ($request->hasFile('logo')) {
            $file_path = $request->file('logo')->store('images/reseller', 'public');
            $reseller->logo = $file_path;
        }

        $data['status'] = 1;
        $reseller->update($data);
        return response()->json([
            'success' => 'OK',
            'message' => 'Information updated successfully ',
        ]);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

         $reseller  = Reseller::find($id);

        if ($reseller->delete()) {
              return response()->json([
                 "success"  => "OK",
                  "message"  => "one reseller removed "
            ]);
        }else {
           return  response()->json([
                "success" => "Fail",
               "message" => "something wrong "
          ]);

        }


}


public function accountAccess($id){
       $reseller=Reseller::findOrFail($id);
        session()->put('reseller',$reseller);
           return response()->json([
               'status'=>"OK",
               'reseller' => $reseller,
               'reseller_token' => 'ASDF#%#454545$%@@@@@@@@2',
           ]);

 }

   public function deactive($id)
    {
        $reseller = Reseller::find($id);
           $reseller->status = 0;
            if ($reseller->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'Reseller deactivate successfully'
                ]);
            }

    }


    function active($id)
    {
        $reseller = Reseller::findOrFail($id);
        $reseller->status = 1;
        $reseller->save();
        //sending login credential
        //(new SmsService())->resellerLoginCredential($reseller,12345678);
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'Reseller active successfully'
        ]);


    }



    public function export_reseller(){

       return Excel::download(new ResellersExport(),'reseller.xlsx') ;
    }




    public function manuallyIncomeSet(Request $request)
    {
        $request->validate([
            'reseller_id' => 'required',
            'comment' => 'required',
            'amount' => 'required',
            'order_invoice' => 'nullable',
        ]);

        if ($request->amount > 0) {
            if($request->order_invoice){
                $order = Order::where('invoice_no', $request->order_invoice)->firstOrFail();
            }
            $cashbook= new ResellerCashbook();
            $cashbook->reseller_id = $request->reseller_id ;
            $cashbook->invoice_no = 222 ;
            $cashbook->is_income = 1 ;
            $cashbook->amount = $request->amount ;
            $cashbook->order_id = $order->id ?? NULL;
            $cashbook->created_by = !empty(session()->get('admin')['id']) ? session()->get('admin')['id'] : null    ;
            $cashbook->note = $request->comment;
            $cashbook->is_extra_amount = 0;
            $cashbook->save();
            //update invoice
            $cashbook->invoice_no = 2222 + $cashbook->id ;
            $cashbook->save();

            // HelperService::resellerCashbookStore(NULL, $request->reseller_id, $request->amount, 1, $request->comment);
        }


        return response()->json([
            'success' => true,
            'message' => 'Income created successfully'
        ]);
    }


    public function manuallyExpenseSet(Request $request){
        $request->validate([
            'reseller_id' => 'required',
            'comment' => 'required',
            'amount' => 'required',
            'order_invoice' => 'nullable',
        ]);

        if ($request->amount > 0) {
            if($request->order_invoice){
                $order = Order::where('invoice_no', $request->order_invoice)->first();
            }
            $cashbook= new ResellerCashbook();
            $cashbook->reseller_id = $request->reseller_id ;
            $cashbook->invoice_no = 222 ;
            $cashbook->is_income = 0;
            $cashbook->amount = $request->amount ;
            $cashbook->order_id = $order->id ?? NULL;
            $cashbook->created_by = !empty(session()->get('admin')['id']) ? session()->get('admin')['id'] : null    ;
            $cashbook->note = $request->comment;
            $cashbook->is_extra_amount = 0;
            $cashbook->save();
            //update invoice
            $cashbook->invoice_no = 2222 + $cashbook->id ;
            $cashbook->save();


            // HelperService::resellerCashbookStore(NULL, $request->reseller_id, $request->amount, 0, $request->comment);
        }

        return response()->json([
            'success' => true,
            'message' => 'Income created successfully'
        ]);
        
    }





    public function storeComment(Request $request)
    {
        $comment = new ResellerComment();
        $comment->reseller_id = $request->reseller_id;
        $comment->comment_id = $request->comment_id;
        $comment->comment = $request->comment;
        $comment->admin_id = session()->get('admin')['id'];
        $comment->save();

        /***** find comment *****/
        $comments = Comment::find($request->comment_id);
        $reseller = Reseller::find($request->reseller_id);
        if($comments){
            $reseller->comment =  $comments->name . ' ' . $request->comment;
        }else{
            $reseller->comment =  $request->comment;
        }
        $reseller->save();
        return response()->json([
            'status' => true,
            'message' => "Comment Added"
        ]);
    }


    public function getComment($id)
    {
        $reseller_comments = ResellerComment::with(['createdBy:id,name', 'selectedComment:id,name'])->where('reseller_id', $id)->get();
        return sendResponseWithData('reseller_comments', $reseller_comments, true, 'get successfully');
    }






}
