<?php

namespace App\Http\Controllers\Admin;

use App\Models\Banner;
use Illuminate\Http\Request;
use App\Models\SaleCampaign ;
use App\Http\Controllers\Controller;

class SaleCampaignController extends Controller
{
      
    
    
public function get_sale_campaign_list() {
    $sale_campaigns = SaleCampaign::orderBy('id','desc')->get();
    return response()->json([
        'status' => "OK",
            'sale_campaigns' => $sale_campaigns,
    ]);
}


   
public function store_sale_campaign(Request $request)
 {

    $request->validate([
    'name'  => 'required',
    'expired_date'  => 'required',
    'border_width'  => 'required',
    ]);
    
    $sale_campaign =new SaleCampaign();
    $sale_campaign->name=$request->name;
    $sale_campaign->expired_date=$request->expired_date;
    $sale_campaign->background_color=$request->background_color;
    $sale_campaign->border_color=$request->border_color;
    $sale_campaign->border_width=$request->border_width;
    $sale_campaign->order_by=$request->order_by;
    $sale_campaign->status=1;
 
    if ($sale_campaign->save()) {
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'Sale campaign added successfully',
        ]);
    }else{
        return response()->json([
            'status' => 'FAIL',
            'message' => 'Expire date is required and something went wrong',
        ]); 
    }
}




public function active_sale_campaign($id) 
{
    $sale_campaign = SaleCampaign::findOrFail($id);
    $sale_campaign->status=1 ;
    if ($sale_campaign->save()) {
        return response()->json([
            "status" => "OK",
            "message" => "this campaign activated",
        ]);
    }
}




public function de_active_sale_campaign($id) {

    $sale_campaign = SaleCampaign::findOrFail($id);
    $sale_campaign->status=0 ;
    if ($sale_campaign->save()) {
        return response()->json([
            "status" => "OK",
            "message" => "this campaign de-activated",
        ]);
     }
  }




    public function destroy_sale_campaign($id) {

        $sale_campaign = SaleCampaign::findOrFail($id);
        if ($sale_campaign->delete()) {
            return response()->json([
                "status" => "OK",
                "message" => "this campaign destroyed",
            ]);
        }
    }






    public function get_edit_campaign($id) {
        $sale_campaign = SaleCampaign::findOrFail($id);
        return response()->json([  
            'status' => "OK",
            'sale_campaign'=>$sale_campaign,
        ]);
    }


     

     
  public function update_sale_campaign(Request $request,$id){

    $request->validate([
        'name'  => 'required',
        'expired_date'  => 'required',
        'border_width'  => 'required',
    ]);

    $sale_campaign = SaleCampaign::findOrFail($id);
    $sale_campaign->name=$request->name;
    $sale_campaign->expired_date=$request->expired_date;
    $sale_campaign->background_color=$request->background_color;
    $sale_campaign->border_color=$request->border_color;
    $sale_campaign->border_width=$request->border_width;
    $sale_campaign->order_by=$request->order_by;
    $sale_campaign->status=1;

    if ($sale_campaign->save()) {
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'Sale campaign updated successfully',
        ]);
    }else{
        return response()->json([
            'status' => 'FAIL',
            'message' => 'Expire date is required and something went wrong',
        ]); 
     }

 }


    public function get_banner(){
        $campaign = Banner::latest()->first();
        if ($campaign) {
            return response()->json([
                "status" => "OK",
                "campaign" => $campaign ,
            ]);
        }
    }



        
    public function update_banner(Request $request,$id){
        // return $request->all();
        $campaign = Banner::findOrFail($id);
        $campaign->url_1=$request->url_1;
        $campaign->url_2=$request->url_2;
        $campaign->status=$request->status;
        if ($request->hasFile('banner_1') ) {
            $banner_path = $request->file('banner_1')->store('images/add_banner', 'public');
            $campaign->banner_1 = $banner_path;
        }

      if ($request->hasFile('banner_2') ) {
            $banner_path = $request->file('banner_2')->store('images/add_banner', 'public');
            $campaign->banner_2 = $banner_path;
        }

        if ($campaign->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'updated successfully',
            ]);
        }

    }





    public function BannerLIst()
    {
        $site = request()->getHttpHost();
        if(substr($site, 0, 4) == 'www.'){
            $site  = substr($site,4);
        }
        $banners = Banner::get();
        return response()->json([
            'status' => 'OK',
            'banners' => $banners,
        ]);
    }



    public function AddBanner(Request $request)
    {

        $validatedData = $request->validate([
            'url' => 'required',
            'placement' => 'required',

        ]);

        $banner = new Banner();
        $banner->url = $request->url;
        $banner->placement = $request->placement;
        $banner->status = 1;
        if ($request->hasFile('banner')) {
            $path = $request->file('banner')->store('images/banner', 'public');
            $banner->banner = $path;
        }
        $banner->save();

        return response()->json([
            'status' => 'OK',
            'message' => 'added successfully',
        ]);
    }



    public function GetBanner(Request $request, $id)
    {
        $banner = Banner::findOrFail($id);
        return response()->json([
            'status' => 'OK',
            'banner' => $banner,
        ]);
    }

    public function UpdateBanner(Request $request, $id)
    {

        $request->validate([
            'url' => 'required',
            'placement' => 'required',
        ]);
        $banner = Banner::findOrFail($id);
        $banner->url = $request->url;
        $banner->placement = $request->placement;
        if ($request->hasFile('banner')) {
            $path = $request->file('banner')->store('images/banner', 'public');
            $banner->banner = $path;
        }
        $banner->save();

        return response()->json([
            'status' => 'OK',
            'message' => 'updated successfully',
        ]);
    }





    public function activeBanner($id)
    {

        $banner = Banner::findOrFail($id);
        $banner->status = 1;
        $banner->save();
        return response()->json([
            'status' => 'OK',
            'message' => 'activated'
        ]);
    }




    public function DeActiveBanner($id)
    {

        $banner = Banner::findOrFail($id);
        $banner->status = 0;
        $banner->save();
        return response()->json([
            'status' => 'OK',
            'message' => 'de-activated'
        ]);
    }






    public function DestroyBanner($id)
    {

        $banner = Banner::findOrFail($id);
        $banner->delete();
        return response()->json([
            'status' => 'OK',
            'message' => 'removed'
        ]);
    }

    

    
    


}
 







