<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Skin;
use Illuminate\Support\Str;
class SkinController extends Controller
{
    public function index()
    {
        $skins = Skin::orderby('id', 'desc')->paginate(30);
        return response()->json([
            'success' => true,
            'skins' => $skins,
        ]);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:skins|',
        ]);
        $skin = new Skin();
        $skin->name = $request->name;
        $skin->slug = Str::slug($request->name);
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/skin', 'public');
            $skin->image = $path;
        }
        if ($skin->save()) {
            return response()->json([
                'success' => true,
                'message' => 'Skin add successfully'
            ]);
        }
    }

    public function active($id)
    {
        $skin = Skin::find($id);
        if ($skin) {
            $skin->status = 1;
            if ($skin->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Skin active successfully'
                ]);
            }
        }
    }

    public function deActive($id)
    {
        $skin = Skin::find($id);
        if ($skin) {
            $skin->status = 0;
            if ($skin->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Skin de-active successfully'
                ]);
            }
        }
    }

    public function search($search)
    {
        $skins = Skin::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->paginate(10);

        if ($skins) {
            return response()->json([
                'success' => true,
                'skins' => $skins,
            ]);
        }
    }

    public function edit($id)
    {
        $skin = Skin::find($id);
        if ($skin) {
            return response()->json([
                'success' => true,
                'skin' => $skin
            ]);
        }
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);
        $skin = Skin::find($id);
        $skin->name = $request->name;
        $skin->slug = Str::slug($request->name);
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/skin', 'public');
            $skin->image = $path;
        }
        if ($skin->save()) {
            return response()->json([
                'success' => true,
                'message' => 'skin update successfully'
            ]);
        }
    }
}
