<?php

namespace App\Http\Controllers\Admin;

use App\Models\Slider;
use Illuminate\Http\Request;
use App\Models\Category_slider;
use App\Models\ResellingSlider;
use App\Http\Controllers\Controller;

class SliderController extends Controller
{
    public function index()
    {
        $sliders = Slider::orderBy('id', 'DESC')->paginate(50);
        return sendResponseWithData('sliders', $sliders, true);
    }

    public function getEditSlider($id){
        $slider = Slider::find($id);
        return sendResponseWithData('slider', $slider, true);
    }


    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required',
        ]);
        $id = Slider::max('id') ?? 1;
        $slider = new Slider();
        $slider->status = 1;
        $slider->position = $id + 1;
        $slider->url = $request->url;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/slider', 'public');
            $slider->image = $path;
        }
        $slider->save();
        return sendResponseWithMessage(true, 'saved successfully');

    }

    public function updateSlider(Request $request , $id){
        $request->validate([
            'url' => 'required',
        ]);

        $slider = Slider::find($id);
        $slider->url = $request->url ;
        $slider->position = $request->position;
        if ($request->hasFile('image')) {
            if (file_exists('storage/'.$slider->image)) {
                unlink('storage/'.$slider->image);
            }
            $path = $request->file('image')->store('images/slider', 'public');
            $slider->image=$path;
        }
        $slider->save();
        return sendResponseWithMessage(true, 'updated successfully');
    }
    public function destroy($id)
    {
        $slider = Slider::find($id);
        $slider->delete();
        return sendResponseWithMessage(true, 'delete successfully');
    }


    public function status($id)
    {
        $slider = Slider::find($id);
        if ($slider->status == 0) {
            $slider->status = 1;
        }else{
            $slider->status = 0;
        }
        $slider->save();
        return sendResponseWithMessage(true, 'Status Changed');
    }
}
