<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SmsService;
use Illuminate\Http\Request;
use App\Models\SmsNumberRecord;
use App\Models\SmsCampaignRecord;
class SmSServiceController extends Controller
{
    public function index()
    {
        $sms = SmsService::orderBy('id', 'desc')->get();
        return response()->json([
            'status' => true,
            'sms' => $sms
        ]);
    }



    public function store(Request $request)
    {
        $this->validate($request, [
            'company_name' => 'required|unique:sms_services',
            'script' => 'nullable',
        ]);

        $sms = new SmsService();
        $sms->company_name = $request->company_name;
        $sms->script = $request->script;
        $sms->save();
        return response()->json([
            'status' => true,
            'message' => "add successfully"
        ]);
    }


    public function edit()
    {
        $sms = SmsService::first();
        return response()->json([
            'status' => true,
            'sms' => $sms
        ]);
    }


    public function update(Request $request)
    {
        $validatedData =  $this->validate($request, [
            'company_name' => 'required',
            'script' => 'required',
            'status' => 'required',
        ]);


        $setting = SmsService::first();
        if ($setting) {
            $setting->update($validatedData);
        } else {
            SmsService::create($validatedData);
        };
        return response()->json([
            'status' => true,
            'message' => " Updated successfully"
        ]);
    }



    public function status($id)
    {
        $sms = SmsService::findOrFail($id);
        if ($sms->status == 1) {
            $sms->status = 0;
        } else {
            $sms->status = 1;
        }
        $sms->save();
        return response()->json([
            'status' => true,
            'message' => 'Status Updated'
        ]);
    }


    public function setDefault($id)
    {
        $sms = SmsService::findOrFail($id);
        $sms->activate();
        return response()->json([
            'status' => true,
            'message' => 'Set Default',
        ]);
    }


    public function activeSource()
    {
        $sms = SmsService::where('status', 1)->get();
        return response()->json([
            'status' => true,
            'sms' => $sms,
        ]);
    }
    public function smsCampaignList()
    {

        $smsCampaigns = SmsCampaignRecord::with('smsList')->orderBy('id', 'DESC')->paginate(10);

        return response()->json([
            'status' => true,
            'smsCampaigns' => $smsCampaigns,
        ]);
    }
}
