<?php

namespace App\Http\Controllers\Admin;

use Exception;
use App\Models\Product;
use App\Models\Category;
use App\Models\SubCategory;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\SubSubCategory;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SubCategoryController extends Controller
{
    public function index()
    {
        $subCategories = SubCategory::with('category:id,name')->paginate(50);
        return response()->json([
            'subCategories' => $subCategories,
            'status' => 'SUCCESS'
        ]);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:sub_categories',
            'category' => 'required',
            'meta_title'=>'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content'  => 'nullable',
        ]);
        $id = SubCategory::max('id') ?? 1;
        $subCategory = new SubCategory();
        $subCategory->name = $request->name;
        $subCategory->category_id = $request->category;
        $subCategory->status = 1;
        $subCategory->slug = Str::slug($subCategory->name);
        $subCategory->meta_title = $request->meta_title;
        $subCategory->meta_description = $request->meta_description;
        $subCategory->meta_key = $request->meta_key;
        $subCategory->meta_content = $request->meta_content;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/subCategory', 'public');
            $subCategory->image = $path;
        }
        $subCategory->save();
        return sendResponseWithMessage(true, 'added successfully');
    }
    public function edit($id)
    {
        $subCategories = SubCategory::find($id);
        if ($subCategories) {
            return response()->json([
                'status' => 'SUCCESS',
                'subCategory' => $subCategories,
            ]);
        }

    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:sub_categories,name,'.$id,
            'category' => 'required',
            'meta_title'=>'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content'  => 'nullable',
        ]);
        $subCategory =SubCategory::find($id);
        $subCategory->name = $request->name;
        $subCategory->slug = Str::slug($subCategory->name);
        $subCategory->category_id = $request->category;
        $subCategory->merchant_commission = $request->merchant_commission;
        $subCategory->status = 1;
        $subCategory->meta_title = $request->meta_title;
        $subCategory->meta_description = $request->meta_description;
        $subCategory->meta_key = $request->meta_key;
        $subCategory->meta_content = $request->meta_content;
        
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/subCategory', 'public');
            $subCategory->image = $path;
        }
        $subCategory->save();
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'sub category update successfully'
        ]);
        
    }


    public function search($search)
    {
        $subCategories = SubCategory::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->with('category')->paginate(10);

        if ($subCategories) {
            return response()->json([
                'subCategories' => $subCategories,
                'status' => 'SUCCESS'
            ]);
        }
    }

    public function status($id)
    {
        $subCategories = SubCategory::find($id);
        if ($subCategories->status == 1) {
            $subCategories->status = 0;
        }else{
            $subCategories->status = 1;
        }
        $subCategories->save();
        return sendResponseWithMessage(true, 'Status Updated');
    }

    public function subCategoryWiseSubCategory($id){
        $subSubCategory=SubSubCategory::where('subcategory_id',$id)->get();
        if ($subSubCategory){
            return response()->json([
                'status'=>'SUCCESS',
                'subsubcategories'=>$subSubCategory
            ]);
        }
    }



    public function addDiscount(Request $request, $id){
        $request->validate([
            'discount' => 'required|integer',
            'discount_type' => 'required',
        ]);

        try{
            DB::beginTransaction();
            $sub_c=SubCategory::findOrFail($id);
            $sub_c->discount=$request->discount;
            $sub_c->discount_type=$request->discount_type;
            $sub_c->save();

            $products=Product::where('sub_category_id',$sub_c->id)->where('status',1)->get();
            foreach ($products as $product) {
                if ($request->discount_type == "flat") {
                    $product->sale_price = $product->price - $request->discount;
                    $product->discount = $request->discount;
                }else{
                    $discount = ($product->price * $request->discount / 100);
                    $product->sale_price = $product->price - $discount;
                    $product->discount = $discount;
                }
                $product->save();
            }
            
            DB::commit();
            return sendResponseWithMessage(true, 'Discount Applied Successfully');
        }catch(Exception $e){
            DB::rollBack();
            return sendResponseWithMessage(false, $e->getMessage());
        }

        
    }




    public function delete($id)
    {
        $sub_category = SubCategory::findOrFail($id);
        if (!$sub_category) {
            return response()->json(['message' => 'Sub category not found'], 404);
        }
    
        if ($sub_category->products()->count() === 0 || $sub_category->subSubCategory->count() === 0) {
            $sub_category->delete();
            return response()->json(['status' => true, 'message' => 'Sub category deleted successfully'], 200);
        } else {
            return response()->json(['message' => 'Sub category is not empty. Delete associated products first.'], 400);
        }
    }
    
    

}
