<?php

namespace App\Http\Controllers\Admin;

use Exception;
use App\Models\Product;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\SubSubCategory;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SubSubCategoryController extends Controller
{
    public function index()
    {
        $subSubCategories = SubSubCategory::orderby('id', 'desc')->with(['category:id,name','subCategory:id,name,category_id'])->paginate(50);
        return response()->json([
            'subSubCategories' => $subSubCategories,
            'status' => 'SUCCESS'
        ]);
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:sub_sub_categories',
            'category' => 'required',
            'subcategory' => 'required',
            'meta_title'=>'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content'  => 'nullable',
        ]);


        $subSubCategory = new SubSubCategory();
        $subSubCategory->name = $request->name;
        $subSubCategory->category_id = $request->category;
        $subSubCategory->subcategory_id = $request->subcategory;
        $subSubCategory->slug = Str::slug($request->name);
        $subSubCategory->status = 1;
        $subSubCategory->meta_title = $request->meta_title;
        $subSubCategory->meta_description = $request->meta_description;
        $subSubCategory->meta_key = $request->meta_key;
        $subSubCategory->meta_content = $request->meta_content;

        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/subSubCategory', 'public');
            $subSubCategory->image = $path;
        }
        if ($subSubCategory->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'sub-sub category add successfully'
            ]);
        }
    }
    public function edit($id)
    {
        $subSubCategory=SubSubCategory::find($id);
        if ($subSubCategory){
            return  response()->json([
                'status'=>'SUCCESS',
                'subSubCategory'=>$subSubCategory
            ]);
        }
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:sub_sub_categories,name,'.$id,
            'category' => 'required',
            'subcategory' => 'required',
            'meta_title'=>'nullable|max:70',
            'meta_key' => 'nullable',
            'meta_description' => 'nullable|max:170',
            'meta_content'  => 'nullable',
        ]);

        $subSubCategory = SubSubCategory::find($id);
        $subSubCategory->name = $request->name;
        $subSubCategory->slug = Str::slug($request->name);
        $subSubCategory->category_id = $request->category;
        $subSubCategory->subcategory_id = $request->subcategory;
        $subSubCategory->status = 1;
        $subSubCategory->meta_title = $request->meta_title;
        $subSubCategory->meta_description = $request->meta_description;
        $subSubCategory->meta_key = $request->meta_key;
        $subSubCategory->meta_content = $request->meta_content;
        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('images/subSubCategory', 'public');
            $subSubCategory->image = $path;
        }
        if ($subSubCategory->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'sub-sub category update successfully'
            ]);
        }
    }

    public function status($id)
    {
        $subSubCategory = SubSubCategory::find($id);
        if ($subSubCategory->status == 1) {
            $subSubCategory->status = 0;
        }else{
            $subSubCategory->status = 1;
        }
        $subSubCategory->save();
        return sendResponseWithMessage(true, 'Status Changed');
        
    }

    public function search($search)
    {
        $subSubCategories = SubSubCategory::where('name', 'like', '%' . $search . '%')->orderBy('id', 'DESC')->with(['category','subCategory'])->paginate(10);

        if ($subSubCategories) {
            return response()->json([
                'subSubCategories' => $subSubCategories,
                'status' => 'SUCCESS'
            ]);
        }
    }
    
    
    

    
    
      public function addDiscount(Request $request, $id){
        $request->validate([
            'discount' => 'required|integer',
            'discount_type' => 'required',
        ]);

        try{
            DB::beginTransaction();
            $sub_sub_c = SubSubCategory::findOrFail($id);
            $sub_sub_c->discount = $request->discount;
            $sub_sub_c->discount_type = $request->discount_type;
            $sub_sub_c->save();

            $products = Product::where('sub_sub_category_id',$sub_sub_c->id)->where('status',1)->get();
            foreach ($products as $product) {
                if ($request->discount_type == "flat") {
                    $product->sale_price = $product->price - $request->discount ;
                    $product->discount = $request->discount;
                }else{
                    $discount = ($product->price * $request->discount / 100);
                    $product->sale_price = $product->price - $discount;
                    $product->discount = $discount;
                }
                $product->save();
            }
            DB::commit();
            return sendResponseWithMessage(true, 'Discount Applied Successfully');
        }catch(Exception $e){
            DB::rollBack();
            return sendResponseWithMessage(false, $e->getMessage());
        }
        
    }




    public function delete($id)
    {
        $sub_sub_category = SubSubCategory::findOrFail($id);
        if (!$sub_sub_category) {
            return response()->json(['message' => 'Sub sub category not found'], 404);
        }
    
        if ($sub_sub_category->products()->count() === 0) {
            $sub_sub_category->delete();
            return response()->json(['status' => true, 'message' => 'Sub sub category deleted successfully'], 200);
        } else {
            return response()->json(['message' => 'Sub sub category is not empty. Delete associated products first.'], 400);
        }
    }





    
    
    
    
    
    
    
    
    
    
    
    
}
