<?php

namespace App\Http\Controllers\Admin;

use Exception;
use App\Models\Purchase;
use App\Models\Supplier;
use Illuminate\Http\Request;
use App\Exports\SupplierExport;
use App\Models\SupplierPayment;
use Barryvdh\DomPDF\Facade as PDF;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

class SupplierController extends Controller
{

    public function __construct()
    {
        return $this->middleware('admin');
        
    }

    public function index(Request $request)
    {
       $item=$request->item??20;
        $suppliers = Supplier::orderBy('id', 'DESC')->where('type',$request->type)->paginate($item);
        $suppliers_id = Supplier::where('type',$request->type)->select('id')->pluck('id');


        foreach($suppliers as $supplier){
            $supplier->{'due'}=Purchase::where('supplier_id',$supplier->id)->sum('total')-SupplierPayment::where('supplier_id',$supplier->id)->sum('amount');
        }
        $total_due_amount=Purchase::whereIn('supplier_id',$suppliers_id)->sum('total')-SupplierPayment::whereIn('supplier_id',$suppliers_id )->sum('amount');;
        return response()->json([
            'status' => 'SUCCESS',
            'suppliers' => $suppliers,
            'total_due_amout' =>number_format($total_due_amount)
        ]);
    }
    public function create()
    {
        
    }
    public function store(Request $request)
    {
        $request->validate([
            'company_name' => 'required',
            'address' => 'required',
            'phone' => 'required|unique:suppliers|digits:11',
            'opening_balance' => 'nullable|integer'
        ]);
        DB::beginTransaction();
        try{
            $supplier = new Supplier();
            $supplier->company_name = $request->company_name;
            $supplier->address = $request->address;
            $supplier->phone = $request->phone;
            $supplier->type = $request->type ?? 1;
            $supplier->save();
            if(!empty($request->opening_balance)){
                $purchase=new Purchase();
                $purchase->total = $request->opening_balance;
                $purchase->supplier_id = $supplier->id;
                $purchase->invoice_no = 0000;
                $purchase->paid = 0;
                $purchase->status = $supplier->type;
                $purchase->purchase_date = date('Y-m-d');
                $purchase->save();
            }
            DB::commit();
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'supplier add successfully'
            ]);
            
        }catch(Exception $e){
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
        
    }

    public function search_supplier($data){

        $suppliers = Supplier::where('company_name','like','%'.$data.'%')
                        ->orWhere('name','like','%'.$data.'%')
                        ->orWhere('phone','like','%'.$data.'%')
                        ->orWhere('address','like','%'.$data.'%')
                        ->paginate(10);

            return response()->json([
            "status" => "OK",
            'suppliers' => $suppliers ,
            ]);   
    }



    public function edit($id)
    {
        $supplier = Supplier::findOrFail($id);
        if ($supplier) {
            return response()->json([
                'status' => 'SUCCESS',
                'supplier' => $supplier
            ]);
        }
    }


    public function update(Request $request, $id)
    {
        $request->validate([
            'company_name' => 'required',
            'address' => 'required',
            'phone' => 'required|digits:11 ',
            'opening_balance' => 'nullable|integer'
        ]);
        $supplier = Supplier::find($id);
        $supplier->name = $request->name;
        $supplier->company_name = $request->company_name;
        $supplier->address = $request->address;
        $supplier->phone = $request->phone;
        $supplier->save();
        if(!empty($request->opening_balance)){
            $purchase=new Purchase();
            $purchase->total = $request->opening_balance;
            $purchase->supplier_id = $supplier->id;
            $purchase->invoice_no = 0000;
            $purchase->paid = 0;
            $purchase->status = $supplier->type;
            $purchase->purchase_date = date('Y-m-d');
            $purchase->save();
        }
        return response()->json([
            'status' => 'SUCCESS',
            'message' => 'supplier update successfully'
        ]);
    }

    public function active($id)
    {
        $supplier = Supplier::find($id);
        if ($supplier) {
            $supplier->status = 1;
            if ($supplier->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'supplier active successfully'
                ]);
            }
        }
    }

    public function deActive($id)
    {
        $supplier = Supplier::find($id);
        if ($supplier) {
            $supplier->status = 0;
            if ($supplier->save()) {
                return response()->json([
                    'status' => 'SUCCESS',
                    'message' => 'supplier de-active successfully'
                ]);
            }
        }
    }

    public function supplierAmountList($id){

         $total_paid_item=SupplierPayment::with('balance:id,name')->where('supplier_id',$id)->orderBy('date','DESC')->get();
         $purchase_items=Purchase::where('supplier_id',$id)->with('purchaseItems')->orderBy('id','desc')->get();
         $supplier_amount=array();
         $supplier_amount['total_purchase_amount']=Purchase::where('supplier_id',$id)->sum('total');
         $supplier_amount['total_paid_amount']=$total_paid_item->sum('amount');
         $supplier=Supplier::where('id',$id)->first();
         
         return response()->json([
             'amount'=>$supplier_amount,
             'paid_items'=>$total_paid_item,
             'supplier'=>$supplier,
             'purchase_items'=>$purchase_items
         ]);
    }

    public function supplierList(){
        $suppliers=Supplier::where('status',1)->get();
            return response()->json($suppliers);
    }


    public function  export_supplier(){
        return Excel::download(new SupplierExport, 'supplier.xlsx');
    }


    public function pdfSupplierPurchase($id){

         $p_items=Purchase::where('supplier_id',$id)->orderBy('id','DESC')->with('purchaseItems')->get();
         $supplier=Supplier::where('id',$id)->first();

         $total_paid_items=SupplierPayment::where('supplier_id',$id)->orderBy('date','DESC')->get();
         $supplier_amount=array();
         $supplier_amount['total_purchase_amount']=intval(Purchase::where('supplier_id',$id)->sum('total'));
         $supplier_amount['total_paid_amount']=intval($total_paid_items->sum('amount'));
         $supplier_amount['total_due_amount']= $supplier_amount['total_purchase_amount']-$supplier_amount['total_paid_amount'];
         $pdf=PDF::loadView('admin.pdf.supplier',compact('p_items','supplier','supplier_amount'));

          return $pdf->stream();
    }


 public function pdfSupplierAmount($id){
        $total_paid_items=SupplierPayment::where('supplier_id',$id)->orderBy('date','DESC')->get();
         $supplier=Supplier::where('id',$id)->first();
         $supplier_amount=array();
         $supplier_amount['total_purchase_amount']=intval(Purchase::where('supplier_id',$id)->sum('total'));
         $supplier_amount['total_paid_amount']=intval($total_paid_items->sum('amount'));
         $supplier_amount['total_due_amount']= $supplier_amount['total_purchase_amount']-$supplier_amount['total_paid_amount'];
         $pdf=PDF::loadView('admin.pdf.supplierPayment',compact('total_paid_items','supplier','supplier_amount'));

         return $pdf->stream();
    }


    
    
    
    
     



    public function delete($id)
    {
        $supplier = Supplier::findOrFail($id);

        if (!$supplier) {
            return response()->json(['message' => 'Supplier not found'], 404);
        }
    
        if ($supplier->purchases()->count() === 0) {
            $supplier->delete();
            return response()->json(['status' => true, 'message' => 'Supplier deleted successfully'], 200);
        } else {
            return response()->json(['message' => 'Supplier is not empty. Delete associated products first.'], 400);
        }
        
    }

}
