<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BackgroundAndColor;

class ThemeSettingController extends Controller
{
      
    public function get_theme_info() {

        $setting = BackgroundAndColor::latest()->take(1)->first();
        if ($setting) {
            return response()->json([
                "status" => "OK",
                "setting" => $setting ,
            ]);
        }

  }

 
public function edit_theme_info(Request $request,$id)
  {
    
        $setting = BackgroundAndColor::findOrFail($id);
        $setting->primary_color             =   $request->primary_color;
        $setting->primary_text_color        =   $request->primary_text_color;
        $setting->primary_hover_color       =   $request->primary_hover_color;
        $setting->menu_background_color     =   $request->menu_background_color;
        $setting->menu_text_color           =   $request->menu_text_color;
        $setting->menu_hover_color          =   $request->menu_hover_color;
        $setting->footer_background_color   =   $request->footer_background_color;
        $setting->footer_text_color         =   $request->footer_text_color;
        $setting->footer_hover_color        =   $request->footer_hover_color;
        $setting->button_text_color         =   $request->button_text_color;
        $setting->default_border_color      =   $request->default_border_color;
        $setting->default_box_color         =   $request->default_box_color;

        $setting->add_to_card_background_color   =   $request->add_to_card_background_color;
        $setting->add_to_card_text_color         =   $request->add_to_card_text_color;
        $setting->add_to_card_border_color       =   $request->add_to_card_border_color;
        $setting->add_to_card_hover_color        =   $request->add_to_card_hover_color;
        
        $setting->single_page_add_to_card_bg_color             =   $request->single_page_add_to_card_bg_color;
        $setting->single_page_add_to_card_text_color           =   $request->single_page_add_to_card_text_color;
        $setting->single_page_add_to_card_border_color         =   $request->single_page_add_to_card_border_color;
        $setting->single_page_add_to_card_hover_bg_color       =   $request->single_page_add_to_card_hover_bg_color;
        $setting->single_page_add_to_card_hover_text_color     =   $request->single_page_add_to_card_hover_text_color;
        $setting->single_page_add_to_card_hover_border_color   =   $request->single_page_add_to_card_hover_border_color;

        $setting->discount_price_color   =   $request->discount_price_color;

        if ($setting->save()) {
            return response()->json([
                'status' => 'SUCCESS',
                'message' => 'Theme updated successfully',
            ]);
        }

    }




  
}
