<?php

namespace App\Http\Controllers\Frontend\Auth;

use App\Models\Merchant;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class MerchantRegisterController extends Controller
{


    public function merchantLoginRegister()
    {
        return view('frontend.pages.auth.merchant.merchant_login_register');
    }


    public function merchantRegister()
    {
        return view('frontend.pages.auth.merchant.merchant_register');
    }




    public function merchantRegisterStore(Request $request)
    {
        // return $request->all();
        $data = $request->validate([
            'name' => 'required',
            'phone' => 'required|unique:merchants|digits:11',
            'address' => 'required',
            'company_name' => 'required | unique:merchants',
            'password' => 'required | min:8',
            'confirm_password' => 'required|min:8|same:password',
        ]);

        if ($request->hasFile('image')) {
            $img_path=$request->file('image')->store('images/merchant','public');
            $data['image']=$img_path ;
        }

        if ($request->hasFile('nid_image')) {
            $nid_path=$request->file('nid_image')->store('images/merchant','public');
            $data['nid_image']=$nid_path ;
        }

        $data['password']=Hash::make($request->password);
        $data['status'] = 0 ;
        Merchant::query()->create($data);
        return view('frontend.pages.auth.merchant.merchant_register_success')->with('message','Register Successfully');
    }
}
