<?php

namespace App\Http\Controllers\Frontend\Auth;

use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Session;

class LogInController extends Controller
{
    public function index(){
        return view('frontend.pages.auth.login');
    }

    public function store(Request $request){
        $data = $request->validate([
            'phone' => ['required', 'string', 'max:11'],
            'password' => ['required'],
        ]);

        $credential = ['phone' => $data['phone'], 'password' => $data['password']];
        if (!Auth::guard('customer')->attempt($credential)) {
            return redirect()->route('login')->withErrors(['error' => 'Your given credentials do not match our records']);
        }
        else{
            return redirect(RouteServiceProvider::DASHBOARD);
        }

    }



    public function resellerMerchant()
    {
        return view('frontend.pages.auth.reseller.reseller_merchant');
    }



    //function for login reseller
    public function check_login(Request $request)
    {
        $validateData = $request->validate([
            'phone' => 'required',
            'password' => 'required',
        ]);

        $credential = [
            'phone' => $request->phone,
            'password' => $request->password,
            'status' => '1',
        ];

        if (Auth::guard('reseller')->attempt($credential)) {
            Session::put('reseller', Auth::guard('reseller')->user());
            $reseller = Reseller::where('phone',$request->phone)->first();
            $reseller->last_login_date = Carbon::now();
            $reseller->save();
            return redirect(RouteServiceProvider::DASHBOARD);

            return response()->json([
                'status' => true,
                'reseller' => Auth::guard('reseller')->user(),
                'reseller_token' => Hash::make($request->password),
                'message' => 'সফল ভাবে লগইন হয়েছে',
            ]);
        } else {
            $reseller = Reseller::where('phone',$request->phone)->first();
            if($reseller->status == 0){
                return response()->json([
                    'status' => 'inactive',
                    'message' => 'আপনার অ্যাকাউন্ট এখন ইন একটিভ আছে । খুব শীঘ্রই আমাদের প্রতিনিধি আপনার তথ্যাবলী ভ্যারিফাই করে এক্টিভ করে দিবে। এক্টিভ করার পর আপনি আপনার দেওয়া মোবাইল নাম্বার এবং পাসওয়ার্ড দিয়ে লগিন করে ব্যবসায়িক কার্যক্রম শুরু করতে পারবেন। স্বপ্নীল এর সাথে যুক্ত হওয়ার জন্য আপনাকে ধন্যবাদ।'
                ]);
            }else{
                return response()->json([
                    'status' => 'Fail',
                    'message' => 'আপনার দেওয়া মোবাইল নাম্বার এবং পাসওয়ার্ড আমাদের রেকর্ডের সাথে মিলেনি',
                ]);
            }
        }
    }




    


}
