<?php

namespace App\Http\Controllers\Frontend\Auth;
use Throwable;
use App\Models\Reseller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ResellerRegisterController extends Controller
{


    public function userResellerLogin()
    {
        return view('frontend.pages.auth.reseller.user_reseller_login');
    }


    public function resellerRegister()
    {
        return view('frontend.pages.auth.reseller.reseller_register');
    }





    public function resellerRegisterStore(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'company_name' => 'required',
            'email' => 'nullable|unique:resellers',
            'phone' => 'required|unique:resellers|digits:11',
            'address' => 'required',
            'refer_id' => 'nullable',
            'password' => 'required|min:8',
            'confirm_password' => 'required|min:8|same:password',
        ]);
        //check refer id
        if (!empty($data['refer_id'])) {
            $is_exist = Reseller::where('username', $data['refer_id'])->first();
            if (empty($is_exist)) {
                return response()->json([
                    'status' => 'invalid_referred_id',
                    'message' => 'this refer id is not valid',
                ]);
            }
        }
        $r_id = Reseller::max('id') + 001;
        $data['username'] = 'reseller' . $r_id;
        $data['status'] = 2;
        $data['password'] = Hash::make($request->password);
        if ($request->hasFile('logo')) {
            $logo_image = $request->file('logo')->store('images/logo', 'public');
            $data['logo'] = $logo_image;
        }

        if ($request->hasFile('nid_image')) {
            $nid_image = $request->file('nid_image')->store('images/logo', 'public');
            $data['nid_image'] = $nid_image;
        }

        Reseller::query()->create($data);
        return view('frontend.pages.auth.reseller.reseller_register_success')->with('message','Register Successfully');
        
    }
}
