<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Author;
use App\Models\Product;
use App\Models\Publisher;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class AuthorController extends Controller
{
    public function index()
    {
        $authors = Author::where('status', 1)->orderBy('id', 'asc')->Paginate(8);
        $populerAuthors = Author::where('status', 1)->orderBy('clicks', 'DESC')->take(7)->get();

        $data = [
            'authors' => $authors,

            'populerAuthors' => $populerAuthors,
        ];
        return view('frontend.pages.author.index', $data);
    }

    public function autherDetails($slug)
    {
        $authorDetails = Author::where('slug', $slug)->firstOrFail();
        $id = $authorDetails->id;
        $sessionKey = 'authorDetails_viewed_' . $id;
        if (!Session::has($sessionKey)) {
            $authorDetails->incrementClicks();
            Session::put($sessionKey, true);
        }
        $authorBooks = Product::select('id', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'name', 'avg_review', 'product_code', 'thumbnail_img', 'video_url', 'slug', 'stock', 'sale_price', 'discount', 'price', 'stock', 'status', 'details', 'meta_title', 'meta_description', 'meta_key', 'review_ratings', 'avg_review', 'author_id', 'publisher_id', 'created_at','is_book')->where('is_book', 1)
            ->where('status', 1)
            ->where('author_id', $authorDetails->id)
            ->orderBy('id', 'asc')
            ->paginate(50);

        $total_books   = Product::where('is_book', 1)
            ->where('status', 1)
            ->where('author_id', $authorDetails->id)
            ->count();
        $data = [
            'authorDetails' => $authorDetails,
            'authorBooks' => $authorBooks,
            'total_books' => $total_books,
        ];


        return view('frontend.pages.author.author_details', $data);
    }

    public function publisher()
    {

        $publishers = Publisher::where('status', 1)->orderBy('id', 'asc')->Paginate(18);

        $data = [
            'publishers' => $publishers,
        ];
        return view('frontend.pages.publisher.index', $data);
    }

    public function publisherDetails($slug)
    {

        $pubDetails = Publisher::where('slug', $slug)->firstOrFail();
        $publisherBooks = Product::select('id', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'name', 'avg_review', 'product_code', 'thumbnail_img', 'video_url', 'slug', 'stock', 'sale_price', 'discount', 'price', 'stock', 'status', 'details', 'meta_title', 'meta_description', 'meta_key', 'review_ratings', 'avg_review', 'author_id', 'publisher_id', 'created_at','is_book')
            ->where('is_book', 1)
            ->where('status', 1)
            ->where('publisher_id', $pubDetails->id)
            ->orderBy('id', 'asc')
            ->paginate(50);
        $total_books   = Product::where('is_book', 1)
            ->where('status', 1)
            ->where('author_id', $pubDetails->id)
            ->count();
        $data = [
            'pubDetails' => $pubDetails,
            'publisherBooks' => $publisherBooks,
            'total_books' => $total_books,
        ];
        return view('frontend.pages.publisher.publisher_details', $data);
    }
}
