<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Benefit;
use App\Models\Product;
use App\Models\Solution;
use App\Models\Description;
use App\Models\LandingPage;
use App\Models\ProductChild;
use Illuminate\Http\Request;
use App\Models\FooterSetting;
use App\Models\ProductReview;
use App\Models\DeliveryCharge;
use App\Models\GeneralSetting;
use App\Models\ProductVariant;
use App\Models\ProductChildVariant;
use App\Http\Controllers\Controller;
use Gloudemans\Shoppingcart\Facades\Cart;

class LandingPageController extends Controller
{
    public function index($slug)
    {
        // return $slug;
        if (Cart::count() ==  0) {
            $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
            Product::where('is_auto_cart', 1)->where('landing_page_id', $page->id)->where('status', 1)->orderBy('id', 'desc')->get()->each(function ($product) {
                Cart::add([
                    'id' => $product->id,
                    'name' => $product->name,
                    'slug' => $product->slug,
                    'qty' => 1,
                    'price' => $product->sale_price,
                    'weight' => 0,
                    'tax' => 0,
                    'options' => [
                        'original_price' => $product->price,
                        'image' => $product->thumbnail_img,
                    ],
                ]);
            });
        }
        return view('frontend.components.landing_page');
    }



    public static function getProducts($slug)
    {
        $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();

        $products = Product::where('landing_page_id', $page->id)->where('status', 1)->where('is_auto_cart', '!=', 1)->select('id', 'name', 'product_code', 'price', 'sale_price', 'slug', 'discount', 'thumbnail_img')->orderBy('id', 'desc')->take(4)->get();
        return response()->json([
            'success' => true,
            'products' => $products,
        ]);
    }



    public function getDescriptions($slug)
    {


        $landing_page = LandingPage::where('status', 1)->where('page_slug', $slug)->select('id')->firstOrFail();
        $descriptions = Description::where('landing_page_id', $landing_page->id)->where('status', 1)->orderBy('id', 'desc')->select('id', 'title')->get();

        return response()->json([
            'status' => true,
            'descriptions' => $descriptions,
        ]);
    }


    public function reviews($slug)
    {
        $landing_page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $reviews = ProductReview::where('landing_page_id', $landing_page->id)->where('status', 1)->orderBy('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'reviews' => $reviews,
        ]);
    }



    public function generalSetting()
    {
        $general_setting = GeneralSetting::latest()->first();
        return response()->json([
            'general_setting' => $general_setting,
        ]);
    }

    public function footerSetting()
    {

        $footer_setting = FooterSetting::latest()->first();
        return response()->json([
            'footer_setting' => $footer_setting,
        ]);
    }







    public function deliveryCharge()
    {
        $deliveryCharge = DeliveryCharge::all();
        return response()->json([
            'success' => true,
            'deliveryCharge' => $deliveryCharge,
        ]);
    }



    public function getProductVariants($productId)
    {
        $variants = ProductVariant::with('variant')->where('product_id', $productId)->where('attribute_id', 1)->get();
        $cartItem = Cart::content()->where('id', $productId)->first();
        $selectedVariantName = $cartItem ? $cartItem->options->variants['Size'] ?? '' : '';
        return response()->json([
            'success' => true,
            'variants' => $variants,
            'selected_variant_name' => $selectedVariantName,
        ], 200);
    }




    public function autoCartProduct()
    {

        if (Cart::total() == 0) {
            $products = Product::where('is_auto_cart', 1)->where('status', 1)->orderBy('id', 'desc')->get()->each(function ($product) {
                Cart::add([
                    'id' => $product->id,
                    'name' => $product->name,
                    'slug' => $product->slug,
                    'qty' => 1,
                    'price' => $product->sale_price,
                    'weight' => 0,
                    'tax' => 0,
                    'options' => [
                        'original_price' => $product->price,
                        'image' => $product->thumbnail_img,
                        'is_free_delivery' => $product->is_free_delivery,
                    ],
                ]);
            });

            return response()->json([
                'products' => $products,
            ]);
        } else {
            return response()->json([
                'message' => 'Called',
            ]);
        }
    }
}