<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\FilterProductTrait;
use App\Models\SiteConfiguration;

class ProductFilteringController extends Controller
{

    use FilterProductTrait;

    protected  $site_configuration;

    public function __construct()
    {
        $this->site_configuration = SiteConfiguration::select('template_id', 'position_wise_product', 'active_server_side')->first();
    }

    public function sortSelectWiseProducts(Request $request)
    {
        $category_slug = $request->category_slug;
        $query = Product::query()
            ->select(
                'products.id',
                'products.name',
                'products.status',
                'products.thumbnail_img',
                'products.slug',
                'products.stock',
                'products.review_ratings',
                'products.avg_review',
                'products.sale_price',
                'products.discount',
                'products.price',
                'products.created_at'
            );

        switch ($request->sort) {
            case 'new':
                $query->orderBy('created_at', 'desc');
                break;
            case 'high_to_low':
                $query->orderBy('sale_price', 'desc');
                break;
            case 'low_to_high':
                $query->orderBy('sale_price', 'asc');
                break;
            default:
                break;
        }
        if ($category_slug) {
            $category = DB::table('categories')->where('slug', $category_slug)->select('id', 'name', 'slug')->first();
            if ($category) {
                $query->join('product_categories', 'products.id', '=', 'product_categories.product_id')
                    ->where('product_categories.category_id', $category->id);
            }
        }

        $products = $query->get();
        $data = "";
        foreach ($products as $product) {
            $template = 'template' . $this->site_configuration->template_id;
            $data .= view("frontend.components.load_more_product_content.$template", compact('product'))->render();
        }

        return response()->json([
            'products' => $products,
            'data' => $data,
            'product_length' => $products->count(),
        ]);
    }

    public function filterProductsWithPrice(Request $request)
    {
        $minPrice = $request->min_price;
        $maxPrice = $request->max_price;

        $query = Product::query();

        $query->where('status', 1)
            ->whereBetween('sale_price', [$minPrice, $maxPrice]);

        $products = $query->orderBy('sale_price', 'asc')
            ->select('id', 'category_id', 'name', 'status', 'stock', 'thumbnail_img', 'video_url', 'slug', 'sale_price', 'discount', 'price')
            ->get();

        $data = "";
        foreach ($products as $product) {
            $template = 'template' . $this->site_configuration->template_id;
            $data .= view("frontend.components.load_more_product_content.$template", compact('product'))->render();

        }

        return response()->json([
            'data' => $data,
            'product_length' => $products->count(),
        ]);
    }


    public function filterProductsWithBrandName(Request $request)
    {
        $products = $this->filterByType($request, 'productBrands','brand_id');

        $data = "";
        foreach ($products as $product) {
            $template = 'template' . $this->site_configuration->template_id;
            $data .= view("frontend.components.load_more_product_content.$template", compact('product'))->render();
        }
        return response()->json([
            'status' => true,
            'data' => $data,
            'product_length' => $products->count(),
            'message' => 'Loaded data',
        ]);
    }
    public function filterProductsWithCountryName(Request $request)
    {

        $products = $this->filterByType($request, 'productCountrys','country_id');

        $data = "";
        foreach ($products as $product) {
            $template = 'template' . $this->site_configuration->template_id;
            $data .= view("frontend.components.load_more_product_content.$template", compact('product'))->render();
        }
        // Return the response
        return response()->json([
            'status' => true,
            'data' => $data,
            'product_length' => $products->count(),
            'message' => 'Loaded data',
        ]);
    }
    public function filterProductsWithSubSubCategories(Request $request)
    {
        $sub_sub_category_ids = $request->input('subSubCategoryWiseProduct', []);
        $category_slug = $request->category_slug;
        $query = Product::where('status', 1)
            ->select(
                'products.id',
                'products.name',
                'products.status',
                'products.thumbnail_img',
                'products.slug',
                'products.stock',
                'products.review_ratings',
                'products.avg_review',
                'products.sale_price',
                'products.discount',
                'products.price',
                'products.created_at'
            )
            ->orderBy('products.created_at', 'desc'); 

        if ($category_slug) {
            $category = DB::table('categories')->where('slug', $category_slug)->select('id', 'name', 'slug')->first();
            if ($category) {
                $query->join('product_categories', 'products.id', '=', 'product_categories.product_id')
                    ->where('product_categories.category_id', $category->id);
            }
        }

        if ($sub_sub_category_ids) {
            $query->join('product_sub_sub_categories', 'products.id', '=', 'product_sub_sub_categories.product_id')
                ->whereIn('product_sub_sub_categories.sub_sub_category_id', $sub_sub_category_ids);
        }

        $products = $query->get();

        // Render view for each product
        $data = "";
        foreach ($products as $product) {
            $template = 'template' . $this->site_configuration->template_id;
            $data .= view("frontend.components.load_more_product_content.$template", compact('product'))->render();

        }

        // Return the response
        return response()->json([
            'status' => true,
            'data' => $data,
            'product_length' => $products->count(),
            'message' => 'Loaded data',
        ]);
    }
}
