<?php

namespace App\Http\Controllers\Frontend\User;

use App\Models\Customer;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\CustomerCashbook;

class AffiliateController extends Controller
{
    public function index()
    {

        return view('frontend.pages.affiliate.index');
    }

    public function withdrawalList($id)
    {
        $customer = Customer::findOrFail($id);
        $withdrawal = CustomerCashbook::where('type', 'affiliate')
        ->orderBy('id', 'desc')
        ->where('is_income', 0)
        ->where('customer_id', $customer->id)
        ->get();

        return view('frontend.pages.affiliate.withdrawal', compact('withdrawal'));
    }


    public function commissionList($id)
    {
        $customer = Customer::findOrFail($id);
        $withdrawal = CustomerCashbook::where('type', 'affiliate')
        ->orderBy('id', 'desc')
        ->where('is_income', 1)
        ->where('customer_id', $customer->id)
        ->get();

        return view('frontend.pages.affiliate.commission', compact('withdrawal'));
    }
}
