<?php

namespace App\Http\Controllers\Frontend\User;

use App\Models\Customer;
use App\Services\LogTracker;
use Illuminate\Http\Request;
use App\Models\CustomerCashbook;
use App\Services\FrontendService;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class InfluencerIncomeController extends Controller
{
  public function index($id)
  {
    // $customer = Customer::findOrFail($id);

    // Fetch total orders where the customer's coupon was used
    $orders = DB::table('orders')
      ->join('coupons', 'orders.coupon_id', '=', 'coupons.id')
      ->join('customers', 'customers.id', '=', 'coupons.influencer_id')
      ->where('customers.id', $id)
      ->select('orders.*', 'coupons.code as coupon_code', 'customers.name as customer_name')
      ->get();
    $totalOrders = $orders->count();
    $deliveredOrders = $orders->where('status', 5)->count();
    $canceledOrders = $orders->where('status', operator: 6)->count();
    $returnedOrders = $orders->where('status', operator: 7)->count();
    // return $deliveredOrders . $canceledOrders . $returnedOrders;
    return view('frontend.pages.coupon_income.index', compact('totalOrders', 'deliveredOrders', 'canceledOrders', 'returnedOrders'));
  }


  public function withdrawalList($id)
  {
    $customer = Customer::findOrFail($id);
    $withdrawal = CustomerCashbook::where('type', 'coupon')->orderBy('id', 'desc')->where('is_income', 0)->where('customer_id', $customer->id)->get();
    return view('frontend.pages.coupon_income.withdrawal', compact('withdrawal'));
  }


  public function commissionList($id)
  {
    $customer = Customer::findOrFail($id);
    $withdrawal = CustomerCashbook::where('type', 'coupon')->orderBy('id', 'desc')->where('is_income', 1)->where('customer_id', $customer->id)->get();
    return view('frontend.pages.coupon_income.commission', compact('withdrawal'));
  }

  
}
