<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Admin\OrderController;
use Carbon\Carbon;
use App\Models\Order;
use App\Services\LogTracker;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PathaoWebhookController extends Controller
{
  public function handle(Request $request)
  {

    $expectedSecret = 'f3992ecc-59da-4cbe-a049-a13da2018d51';

    $data = $request->all();
    Log::info('Valid webhook received', $data);

    $merchantOrderId = $data['merchant_order_id'] ?? null;
    $orderStatus = $data['order_status'] ?? null;

    Log::info('Pathao Order Status: ' . ($orderStatus ?: 'N/A'));

    // Find order
    $order = Order::where('invoice_no', $merchantOrderId)->first();

    if ($order && $orderStatus) {
      if ($orderStatus === 'Delivered') {
        $order->status = 5; // Delivered
        $order->delivery_date = Carbon::now();
      } else if ($orderStatus === 'Return' || $orderStatus === 'Paid Return') {
        $order->status = 11; // Returned
        $order->return_date = Carbon::now();
      } else if ($orderStatus === 'Partial Delivery') {
        $order->status = 10;
      }

      if ($order->isDirty('status')) {
        $order->save();
      }
    } else {
      Log::warning('Order not found or missing status', [
        'merchant_order_id' => $merchantOrderId,
        'order_status' => $orderStatus
      ]);
    }

    return response('OK', 202)
      ->header('X-Pathao-Merchant-Webhook-Integration-Secret', $expectedSecret);
  }
}
