<?php

namespace App\Http\Controllers\Reseller\API;

use Exception;
use HelperService;
use App\Models\City;
use App\Models\Order;
use App\Models\Product;
use App\Models\Customer;
use App\Models\Reseller;
use App\Models\OrderItem;
use App\Services\SmsService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class OrderController extends Controller
{
    public function store(Request $request)
    {
        if(!empty($request->orders)){
            DB::beginTransaction();
            try {
                $order_response = [];
                foreach ($request->orders as $new_order) {
                    $data = [
                        'customer_phone'            => $new_order['customer_phone'],
                        'city_id'                   => $new_order['city_id'],
                        'sub_city_id'               => $new_order['sub_city_id'],
                        'order_type'                => 4,
                        'status'                    => 2,
                        'note'                      => $new_order['note'],
                        'shipping_cost'             => $new_order['shipping_cost'],
                        'regular_shipping_cost'     => $new_order['regular_shipping_cost'],
                        'total'                     => $new_order['total'],
                        'discount'                  => $new_order['discount'],
                        'paid'                      => $new_order['paid'],
                        'address'                   => $new_order['customer']['customer_address'],
                        'name'                      => $new_order['customer']['customer_name'],
                        'referred_name'             => $new_order['reseller']['reseller_name'],
                        'referred_phone'            => $new_order['reseller']['reseller_phone'],
                        'referred_address'          => $new_order['reseller']['reseller_address'],
                    ];

                    //first find find the customer
                    $customer = Customer::where('phone', $data['customer_phone'])->first();
                    $city = City::findOrFail($data['city_id']);
                    !empty($customer) ? $customer->update($data) :  Customer::storeCustomer($data);
                    $customer = Customer::where('phone', $data['customer_phone'])->first();
                    $customer->reseller_id = 5906;
                    $customer->save();


                    //create order
                    $order = new Order();
                    $order->invoice_no = 1234;
                    $order->reseller_id = 5906;
                    $order->is_referred = 1;
                    $order->referred_name = $data['referred_name'];
                    $order->referred_phone = $data['referred_phone'];
                    $order->referred_address = $data['referred_address'];
                    $order->status = $data['status'];
                    $order->shipping_cost = $data['shipping_cost'];
                    $order->profit = 0;
                    $order->regular_shipping_cost = $data['regular_shipping_cost'];
                    $order->city_id = $data['city_id'];
                    $order->sub_city_id = $data['sub_city_id'];
                    $order->total = $data['total'];
                    $order->customer_id = $customer->id;
                    $order->customer_phone = $customer->phone;
                    $order->note = $data['note'];
                    $order->discount = $data['discount'];
                    $order->paid = $data['paid'];
                    $order->advance_paid = $data['paid'];
                    $order->order_type = $data['order_type'];
                    $order->save();

                    //profit calculation
                    $sale_price = 0;
                    $custom_reselling_price = 0;
                    $sale_price_with_profit_price = 0;


                    foreach ($new_order['order_items'] as $item) {
                        $item_product = Product::where('product_code', $item['product_code'])->where('status', 1)->first();
                        $details = new OrderItem();
                        $details->order_id = $order->id;
                        $details->product_id = $item_product['id'];
                        $details->quantity = $item['quantity'];
                        $details->variant_id = $item['variant_id'] ?? null;
                        $details->admin_sale_price = $item_product->sale_price;

                        //checking ten percent profit
                        $ten_percent_profit = $item_product->sale_price / 10;
                        if (intval($item_product->sale_price) + intval($ten_percent_profit) > $item['price']) {
                            $details->price = $item_product->sale_price + $ten_percent_profit;
                            $details->total = ($item_product->sale_price + $ten_percent_profit) * $item['quantity'];
                        } else {
                            $details->price = $item['price'];
                            $details->total = $item['price'] * $item['quantity'];
                        }
                        $details->save();

                        $sale_price += intval($details->admin_sale_price) * intval($item['quantity']);
                        $custom_reselling_price += intval($item['price']) * intval($item['quantity']);
                        $sale_price_with_profit_price += ($item_product->sale_price + $ten_percent_profit) * $item['quantity'];
                    }

                    //checking order profit
                    $profit_calculate = intval($custom_reselling_price) - intval($sale_price);
                    $ten_percent_profit_calculate = intval($sale_price_with_profit_price) - intval($sale_price);
                    $profit = (intval($profit_calculate) - intval($data['discount'])) + (intval($data['regular_shipping_cost']) - intval($data['shipping_cost']));

                    if ($ten_percent_profit_calculate > $profit) {
                        $order->discount = 0;
                        $order->shipping_cost = $city->delivery_charge;
                        $order->profit = $profit_calculate;
                    } else {
                        $order->profit = $profit;
                    }
                    $order->invoice_no = rand(1, 9) . $order->id . rand(1, 9);
                    $order->total_sale_price = $sale_price;
                    $order->save();
                    
                    
                    //generating response
                    $response_item = [
                        'order_id'  => $order->invoice_no,  
                        'invoice_no'  => $new_order['invoice_no'],  
                    ];
                    
                    array_push($order_response, $response_item);
                }
                DB::commit();
                return response()->json([
                    'status' => true,
                    'data'  => $order_response,
                    'message' => 'Order created successfully'
                ]);
            } catch (Exception $e) {
                return response()->json([
                    "status" => 0,
                    'message' => $e->getMessage(),
                ]);
            }
        }
        
    }
}
