<?php

namespace App\Http\Controllers\Reseller\API;

use App\Models\Product;
use Illuminate\Http\Request;
use App\Models\ResellerProduct;
use App\Http\Controllers\Controller;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        $products = Product::select('id','name','category_id','product_code','thumbnail_img','slug','sale_price','discount','price','reselling_price','details','status')->with('productVariant:id,product_id,variant_id','productImage:id,product_id,product_image','productAttribute:id,product_id,attribute_id')->get();
        return response()->json([
            'status' => 200,
            'products' => $products
        ]);
    } 
    
    

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'price' => 'required',
        ]);

        $product = new ResellerProduct();
        $product->name = $request->name;
        $product->price = $request->price;
        $product->save();
        return 'done';
    }
    
}
