<?php

namespace App\Http\Controllers\Reseller;

use session;
use Illuminate\Http\Request;
use App\Models\ResellerCoupon;
use App\Http\Controllers\Controller;

class CouponController extends Controller
{
    public function index()
    {
        $coupons = ResellerCoupon::orderby('id', 'desc')->where('reseller_id', session()->get('reseller')['id'])->get();
        return response()->json([
            'status' => true,
            'coupons' => $coupons, 
        ]);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'code' => 'required|unique:coupons',
            'start_date' => 'required',
            'expire_date' => 'required',
            'discount_amount' => 'required',
            'discount_type' => 'required',
            'discount_minimum_amount' => 'required',
        ]);
        $coupon = new ResellerCoupon();
        $coupon->reseller_id = session()->get('reseller')['id'];
        $coupon->code = $request->code;
        $coupon->start_date = $request->start_date; 
        $coupon->expire_date = $request->expire_date; 
        $coupon->discount_type = $request->discount_type;
        $coupon->discount_amount = $request->discount_amount;
        $coupon->discount_minimum_amount = $request->discount_minimum_amount;
        if ($coupon->save()) {
            return response()->json([
                'status' => true,
                'message' => 'Reseller Coupon added successfully'
            ]);
        }
    }



    public function status($id)
    {
        $coupon = ResellerCoupon::find($id);
        if ($coupon->status == 1) {
            $coupon->status = 0;
        }else{
            $coupon->status = 1;
        }
        $coupon->save();
        return response()->json([
            'status' => true,
            'message' => 'Status Changed'
        ]);
    }

    


    public function edit($id){
        $coupon = ResellerCoupon::find($id);
        return response()->json([
            'coupon' => $coupon
        ]);
    }


    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'code' => 'required|unique:coupons,code,'.$id,
            'start_date' => 'required',
            'expire_date' => 'required',
            'discount_amount' => 'required',
            'discount_type' => 'required',
            'discount_minimum_amount' => 'required',
        ]);

        $coupon = ResellerCoupon::find($id);
        $coupon->code = $request->code;
        $coupon->start_date = $request->start_date; 
        $coupon->expire_date = $request->expire_date; 
        $coupon->discount_type = $request->discount_type;
        $coupon->discount_amount = $request->discount_amount;
        $coupon->discount_minimum_amount = $request->discount_minimum_amount;
        if ($coupon->save()) {
            return response()->json([
                'status' => true,
                'message' => 'ResellerCoupon update successfully'
            ]);
        }
    }


    public function destroy($id){
        
        $coupon=ResellerCoupon::findOrFail($id);
        $coupon->delete();
        return response()->json([
            'status' => true,
            'message' => 'Deleted successfully',
        ]);
    }
}
