<?php

namespace App\Http\Controllers\Reseller;

use Exception;
use Carbon\Carbon;
use App\Models\Bank;
use App\Models\City;
use App\Models\Page;
use App\Models\Order;
use App\Models\Product;
use App\Models\SubCity;
use App\Models\Variant;
use App\Models\Category;
use App\Models\Customer;
use App\Models\Reseller;
use App\Models\OrderItem;
use App\Models\SubCategory;
use Illuminate\Support\Str;
use App\Models\ProductImage;
use App\Models\Testimonials;
use App\Services\LogTracker;
use App\Services\SmsService;
use Illuminate\Http\Request;
use App\Models\ResellingRule;
use App\Models\DeliveryCharge;
use App\Models\GeneralSetting;
use App\Models\ProductVariant;
use App\Models\SubSubCategory;
use App\Services\HelperService;
use App\Models\ProductAttribute;
use App\Models\ResellerCashbook;
use App\Models\ResellerSiteInfo;
use App\Models\ResellingService;
use App\Models\DropshipperScreen;
use App\Models\BackgroundAndColor;
use App\Models\DropshipperProfile;
use Text_LanguageDetect;
use Illuminate\Support\Facades\DB;
use App\Models\DropshipperSiteInfo;
use App\Http\Controllers\Controller;
use App\Models\ResellerProductPrice;
use Illuminate\Support\Facades\Hash;
use App\Models\ResellerPaymentMethod;
use App\Models\ResellerDeliveryCharge;
use App\Models\ResellerBackgroundColor;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Response;
use Gloudemans\Shoppingcart\Facades\Cart;
use App\Models\ResellerPaymentTransaction;
use App\Models\ResellerPaymentTransactionDetail;
use App\Models\ResellerCashbookPaymentTransactionDetail;

class HomeController extends Controller
{
    public function index()
    {
        return view('reseller.index');
    }

    public function cityList()
    {
        $cities = City::where('status', 1)
            ->orderBy('name')
            ->get();
        return response()->json([
            'cities' => $cities,
        ]);
    }

    public function subCityList($city_id)
    {
        $sub_cities = SubCity::where('status', 1)
            ->where('city_id', $city_id)
            ->orderBy('name')
            ->get();
        return response()->json([
            'sub_cities' => $sub_cities,
        ]);
    }

    public function get_current_reseller()
    {
        if (session::has('reseller')) {

            $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
            return response()->json([
                'status' => 'OK',
                'reseller' => $reseller,
            ]);
        }
    }

    public function getPaymentMethod()
    {
        if (session::has('reseller')) {

            $payment_methods = ResellerPaymentMethod::where('reseller_id', session()->get('reseller')['id'])->first();
            return response()->json([
                'status' => 'OK',
                'payment_methods' => $payment_methods,
            ]);
        }
    }

    public function paymentAccountNumber()
    {
        $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
        $reseller_payment_method = ResellerPaymentMethod::with('bank')->where('reseller_id', $reseller->id)->first();
        $wallet_value = $this->resellerWalletValue($reseller->id);

        return response()->json([
            'status' => true,
            'wallet_value' => $wallet_value,
            'reseller_payment_method' => $reseller_payment_method,
        ]);
    }

    public function current_reseller_update(Request $request)
    {
        $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
        $data = $request->validate([
            'name' => 'required',
            'email' => 'nullable',
            'phone' => 'required|digits:11|unique:resellers,phone,' . session()->get('reseller')['id'],
            'username' => 'required|unique:resellers,username,' . session()->get('reseller')['id'],
            'address' => 'required',
            "company_name" => 'required',
            "company_phone" => 'nullable|digits:11|unique:resellers,company_phone,' . session()->get('reseller')['id'],
            "page_name" => 'nullable',
            "page_url" => 'nullable',
            "website_url" => 'nullable|unique:resellers,website_url,' . $reseller->id,
            "address" => 'nullable',
            'facebook_page_iframe' => 'nullable',
            'facebook_domain_verification' => 'nullable',
            'facebook_pixel_code' => 'nullable',
            'google_analytics_code' => 'nullable',
            'google_tag_manager_body' => 'nullable',
            'google_tag_manager_head' => 'nullable',
            'whatsapp_number' => 'nullable',
            'sms_status' => 'nullable',
            'otp_sms' => 'nullable',
            'inside_dhaka' => 'nullable|integer|min:0',
            'outside_dhaka' => 'nullable|integer|min:0',
            'dhaka_suburb' => 'nullable|integer|min:0',
        ]);

        if ($request->hasFile('image')) {
            $file_path = $request->file('image')->store('images/reseller', 'public');
            $reseller->image = $file_path;
        }

        if ($request->hasFile('logo')) {
            $file_path = $request->file('logo')->store('images/reseller', 'public');
            $reseller->logo = $file_path;
        }


        if ($request->hasFile('fav_icon')) {
            $file_path = $request->file('fav_icon')->store('images/reseller', 'public');
            $reseller->fav_icon = $file_path;
        }


        $data['status'] = 1;
        $data['username'] = Str::slug($request->username);
        $data['whatsapp_number'] = $data['whatsapp_number'];
        $data['api_key'] = Hash::make($reseller->phone);

        $reseller->update($data);
        return response()->json([
            'success' => 'OK',
            'message' => 'Information updated successfully ',
        ]);
    }


    public function updatePaymentMethod(Request $request)
    {
        // return $request->all();
        $data = $request->validate([
            "bank_id" => 'nullable',
            "bkash_no" => 'nullable|min:11',
            "nagad_no" => 'nullable|min:11',
            "rocket_no" => 'nullable',
            "bank_account_name" => 'nullable',
            "bank_account_no" => 'nullable',
            "bank_branch_name" => 'nullable',
            'bank_district_name' => 'nullable',
        ]);
        $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
        $payment_method = ResellerPaymentMethod::where('reseller_id', $reseller->id)->first();
        if ($payment_method) {
            $payment_method->reseller_id = $reseller->id;
            $payment_method->bank_id = $data['bank_id'];
            $payment_method->bank_district_name = $data['bank_district_name'];
            $payment_method->bank_branch_name = $data['bank_branch_name'];
            $payment_method->bank_account_name = $data['bank_account_name'];
            $payment_method->bank_account_no = $data['bank_account_no'];
            $payment_method->bkash_no = $data['bkash_no'];
            $payment_method->nagad_no = $data['nagad_no'];
            $payment_method->rocket_no = $data['rocket_no'];
            $payment_method->update();
            return response()->json([
                'success' => true,
                'message' => 'Information updated successfully ',
            ]);
        } else {
            $payment_method = new ResellerPaymentMethod();
            $payment_method->reseller_id = $reseller->id;
            $payment_method->bank_id = $data['bank_id'];
            $payment_method->bank_district_name = $data['bank_district_name'];
            $payment_method->bank_branch_name = $data['bank_branch_name'];
            $payment_method->bank_account_name = $data['bank_account_name'];
            $payment_method->bank_account_no = $data['bank_account_no'];
            $payment_method->bkash_no = $data['bkash_no'];
            $payment_method->nagad_no = $data['nagad_no'];
            $payment_method->rocket_no = $data['rocket_no'];
            $payment_method->save();
            return response()->json([
                'success' => true,
                'message' => 'Information updated successfully ',
            ]);
        }
    }



    public function get_dashboard_highlight_info()
    {
        $reseller_id = session()->get('reseller')['id'];
        $orders = [];
        $order = Order::where('reseller_id', $reseller_id)->where('order_type', '!=', 5)->with(['customer', 'city'])->get();
        $orders_id = Order::where('reseller_id', $reseller_id)->where('order_type', '!=', 5)->select('id')->pluck('id');
        //total order items counter
        $orders['total_order_items'] = OrderItem::whereIn('order_id', $orders_id)->count();
        //total order items
        $orders['total_order'] = $order->count();
        //today order counter
        $orders['today_order'] = $order
            ->where('created_at', '>=', Carbon::today()->startOfDay())
            ->where('created_at', '<=', Carbon::today()->endOfDay())
            ->count();
        //cancel order counter
        $orders['new_order'] = $order->where('status', 1)->count();
        $orders['pending_order'] = $order->where('status', 2)->count();
        $orders['approved_order'] = $order->where('status', 3)->count();
        $orders['shipment_order'] = $order->where('status', 4)->count();
        $orders['return_order'] = $order->where('status', 7)->count();
        $orders['returned_order'] = $order->where('status', 9)->count();
        $orders['cancel_order'] = $order->where('status', 6)->count();
        $orders['packaging_order'] = $order->where('status', 8)->count();
        $orders['total_delivered_order'] = $order->where('status', 5)->count();
        $orders['shipping_cost'] = $order->sum('shipping_cost');

        $delivery_charge = City::whereHas('order', function ($query) use ($reseller_id) {
            $query->where('reseller_id', $reseller_id);
        })->withCount('order')->sum('delivery_charge');

        return response()->json([
            'status' => 'OK',
            'orders' => $orders,
            'delivery_charge' => $delivery_charge,
            'wallet_value' => self::resellerWalletValue(),
            'total_income' => ResellerCashbook::where('reseller_id', $reseller_id)
                ->where('is_income', 1)
                ->sum('amount'),
            'total_pay_off' => ResellerCashbook::where('reseller_id', $reseller_id)
                ->where('is_income', 0)
                ->sum('amount'),
        ]);
    }

    public static function resellerWalletValue($id = null)
    {


        $reseller_id = !empty(session()->get('reseller'))  ?   session()->get('reseller')['id']  : $id;
        $reseller = Reseller::where('id', $reseller_id)->first();

        $credit = ResellerCashbook::where('reseller_id', $reseller_id)->where('is_income', 1)->sum('amount');
        $debit = ResellerCashbook::where('reseller_id', $reseller_id)->where('is_income', 0)->sum('amount');
        $current_balance = intval($credit) - intval($debit);
        $reseller->wallet_value = $current_balance;
        $reseller->save();
        return $current_balance;
    }

    public function paymentWithDrawTransactions(Request $request)
    {
        $item = $request->item ?? 30;
        $transactions = ResellerPaymentTransaction::where('reseller_id', session()->get('reseller')['id'])->orderBy('id', 'desc')->paginate($item);
        return response()->json([
            'status' => 'OK',
            'transactions' => $transactions,
        ]);
    }

    public function paymentWithDrawRequest(Request $request)
    {
        $reseller_id = session()->get('reseller')['id'];
        $reseller = Reseller::findOrFail($reseller_id);
        $general_setting = GeneralSetting::latest()->first();
        $payment_method = ResellerPaymentMethod::where('reseller_id', $reseller->id)->first();
        $general_setting = GeneralSetting::latest()->first();

        $data = $request->validate([
            'amount' => 'required|integer',
            'payment_method' => 'required',
            'note' => 'nullable',
        ]);

        DB::beginTransaction();
        try {

            //checking account information
            $account_no = '';
            $message = '';
            switch ($data['payment_method']) {
                case 'Bank':
                    $account_no = $payment_method->bank_id;
                    break;

                case 'BKASH':
                    $account_no = $payment_method->bkash_no;
                    break;

                case 'NAGAD':
                    $account_no = $payment_method->nagad_no;
                    break;

                case 'ROCKET':
                    $account_no = $payment_method->rocket_no;
                    break;

                default:
                    $message = "Account Not Found";
                    break;
            }


            $data['account_no'] = $account_no;
            //checking wallet amount
            if ($data['amount'] < 100) {
                return response()->json([
                    'status' => 0,
                    'message' => 'Must be more than 100 taka.',
                ]);
            }

            //order profit calculation
            $unsettle_orders = Order::select('id', 'reseller_id', 'is_profit_paid')->where('is_profit_paid', 0)->whereIn('status', [5, 7, 9])->where('reseller_id', $reseller->id)->get();
            $delivered_orders_profit = Order::where('is_profit_paid', 0)->where('status', 5)->where('reseller_id', $reseller->id)->sum('profit');
            $order_advance_amount = Order::where('is_profit_paid', 0)->whereIn('status', [5, 7, 9])->where('reseller_id', $reseller->id)->sum('advance_paid');
            $return_amount = Order::where('is_profit_paid', 0)->whereIn('status', [7, 9])->where('reseller_id', $reseller->id)->sum('return_paid');
            $shipping_amount = Order::where('is_profit_paid', 0)->whereIn('status', [7, 9])->where('reseller_id', $reseller->id)->sum('regular_shipping_cost');
            $cod_charge = Order::where('is_profit_paid', 0)->where('status', 5)->where('reseller_id', $reseller->id)->sum('cod_charge');
            $packaging_charge = Order::where('is_profit_paid', 0)->whereIn('status', [5, 7, 9])->where('reseller_id', $reseller->id)->sum('packaging_charge');
            $total_amount = ($delivered_orders_profit + $return_amount) - ($order_advance_amount +  $shipping_amount + $cod_charge + $packaging_charge);

            //sms count and amount calculation
            if ($reseller->total_sms >= 30) {
                $sms_amount = $reseller->total_sms * $general_setting->sms_charge;
                HelperService::resellerCashbookStore(null, $reseller->id, intval($sms_amount), 0,  intval($sms_amount) . ' tk sms service charge. number of sms ' . $reseller->total_sms, 0);
                $reseller->total_sms = 0;
                $reseller->save();
            }

            //extra credit and debit calculation
            $unsettle_extra_payment = ResellerCashbook::where('reseller_id', $reseller->id)->where('is_extra_amount', 0)->get();
            $extra_payment_credit = ResellerCashbook::where('reseller_id', $reseller->id)->where('is_income', 1)->where('is_extra_amount', 0)->sum('amount');
            $extra_payment_debit = ResellerCashbook::where('reseller_id', $reseller->id)->where('is_income', 0)->where('is_extra_amount', 0)->sum('amount');



            $total_extra_payment = $extra_payment_credit - $extra_payment_debit;
            $data['reseller_id'] = $reseller->id;
            $data['status'] = 0;
            $data['transaction_id'] = 123;
            $data['amount'] = $total_amount + $total_extra_payment;
            $transaction = ResellerPaymentTransaction::query()->create($data);
            $transaction->transaction_id = 'TNX-' . rand(1111, 9999) . $transaction->id;
            $transaction->save();


            //debit from cashbook
            $cashbook = new ResellerCashbook();
            $cashbook->reseller_id = $reseller->id;
            $cashbook->invoice_no = 133;
            $cashbook->is_income = 0;
            $cashbook->amount = $transaction->amount;
            $cashbook->created_by = !empty(session()->get('admin')) ? session()->get('admin')['id'] : null;
            $cashbook->note = ' BDT ' . $transaction->amount . ' debited for  payment with draw request ';
            $cashbook->save();
            //update invoice number
            $cashbook->invoice_no = 2222 + $cashbook->id;
            $cashbook->save();


            //transaction_details
            foreach ($unsettle_orders as $order) {
                $detail = new ResellerPaymentTransactionDetail();
                $detail->reseller_payment_transaction_id = $transaction->id;
                $detail->order_id = $order->id;
                $detail->save();

                //change order is_profit_paid status
                $order = Order::findOrFail($order->id);
                $order->is_profit_paid = 1;
                $order->save();
            }



            //transaction_details
            foreach ($unsettle_extra_payment as $item) {
                $detail = new ResellerCashbookPaymentTransactionDetail();
                $detail->reseller_payment_transaction_id = $transaction->id;
                $detail->reseller_cashbook_id = $item->id;
                $detail->save();

                //change reseller cashbook is_extra_amount status
                $cashbook = ResellerCashbook::findOrFail($item->id);
                $cashbook->is_extra_amount = 1;
                $cashbook->save();
            }



            // (new SmsService())->resellerPaymentWithDrawRequest($reseller, $transaction->amount);
            DB::commit();
            return response()->json([
                'status' => 1,
                'message' => 'request successful',
            ]);
        } catch (\Throwable $e) {
            LogTracker::failLog($e, $reseller_id);
            DB::rollBack();
            return response()->json([
                'status' => 0,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function productList(Request $request)
    {
        $item = $request->item ?? 20;
        $categories = Category::select('id', 'name')->get();
        $sub_categories = '';
        $sub_sub_categories = '';
        $products = '';


        if (!empty($request->category_id) || !empty($request->sub_category_id) ||  !empty($request->sub_sub_category_id)) {
            //fetched sub category and stock
            $sub_categories = $request->category_id ? SubCategory::where('category_id', $request->category_id)->select('id', 'name')->get() : '';
            //sub categories
            $sub_sub_categories = $request->sub_category_id ? SubSubCategory::where('subcategory_id', $request->sub_category_id)->select('id', 'name')->get() : '';
            $category_column_name = '';
            $category_id = '';

            //only category wise
            if (!empty($request->category_id) && $request->category_type == 'category') {
                $category_column_name = 'category_id';
                $category_id = $request->category_id;
                $products = self::getCategoryWiseProducts($category_column_name, $category_id, $item);
            }
            //category and sub category wise
            if (!empty($request->sub_category_id) && $request->category_type == 'sub_category') {
                $category_column_name = 'sub_category_id';
                $category_id = $request->sub_category_id;
                $products = self::getCategoryWiseProducts($category_column_name, $category_id, $item);
            }

            //category and sub sub category wise
            if (!empty($request->sub_sub_category_id) && $request->category_type == 'sub_sub_category') {
                $category_column_name = 'sub_sub_category_id';
                $category_id = $request->sub_sub_category_id;
                $products = self::getCategoryWiseProducts($category_column_name, $category_id, $item);
            }

            return response()->json([
                'categories' => $categories,
                'products' => $products,
                'sub_categories' => $sub_categories,
                'sub_sub_categories' => $sub_sub_categories,
            ]);
        } else {
            $products = Product::orderBy('updated_at', 'DESC')->select('id', 'name', 'slug', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'reselling_price', 'thumbnail_img',  'details', 'status')
                ->where('reselling_price', '>',0)
                ->with(['productVariant.variant', 'productImage', 'resellerProductPrice'])
                ->take(50)->get()->each(function ($product) {
                    $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller')['id'])->first();
                    if ($reseller_price) {
                        $product->{'reseller_price'} =  $reseller_price->price;
                        $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                        $product->{'status'} =  $reseller_price->status;
                    } else {
                        $product->{'reseller_price'} =  $product->reselling_price;
                        $product->{'status'} =  $product->status;
                    }
                });


            return response()->json([
                'categories' => $categories,
                'products' => $products,
                'sub_categories' => $sub_categories,
                'sub_sub_categories' => $sub_sub_categories,
            ]);
        }
    }

    public function findProduct($product_id)
    {
        $product = Product::with('productVariant.variant')->where('id', $product_id)->first();
        return response()->json([
            'status' => true,
            'product' => $product,
        ]);
    }

    public function setResalePrice(Request $request, $id)
    {
        $product = Product::with('productVariant.variant')->where('id', $id)->first();
        $product->reselling_price = $request->reselling_price;
        $product->save();
        return response()->json([
            'status' => true,
            'message' => 'Successfully Set Reselling Price'
        ]);
    }


    public static function getCategoryWiseProducts($category_column_name, $category_id, $paginate_item)
    {
        session()->get('reseller')['id'];

        return Product::where('status', 1)->where($category_column_name, $category_id)->select('id', 'name', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'status', 'details', 'reselling_price', 'thumbnail_img',  'slug')
            ->where('reselling_price','>',0)
            ->with(['productImage', 'productVariant.variant', 'resellerProductPrice'])
            ->take(1000)
            ->get()->each(function ($product) {
                $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller')['id'])->first();
                if ($reseller_price) {
                    $product->{'reseller_price'} =  $reseller_price->price;
                    $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                    $product->{'status'} =  $reseller_price->status;
                } else {
                    $product->{'reseller_price'} =  $product->reselling_price;
                    $product->{'status'} =  $product->status;
                }
            });
    }

    public function searchProduct($search)
    {
        if (!is_numeric($search)) {
            $products = Product::where('status', 1)->where('name', 'like', '%' . $search . '%')
                ->with(['productVariant.variant', 'productImage', 'resellerProductPrice'])->take(10)
                ->take(1000)->get()->each(function ($product) {
                    $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller')['id'])->first();
                    if ($reseller_price) {
                        $product->{'reseller_price'} =  $reseller_price->price;
                        $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                        $product->{'status'} =  $reseller_price->status;
                    } else {
                        $product->{'reseller_price'} =  $product->reselling_price;
                        $product->{'status'} =  $product->status;
                    }
                });
        } else {
            $products = Product::where('status', 1)->where('product_code', $search)
                ->with(['productVariant.variant', 'productImage', 'resellerProductPrice'])->take(10)
                ->take(1000)->get()->each(function ($product) {
                    $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller')['id'])->first();
                    if ($reseller_price) {
                        $product->{'reseller_price'} =  $reseller_price->price;
                        $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                        $product->{'status'} =  $reseller_price->status;
                    } else {
                        $product->{'reseller_price'} =  $product->reselling_price;
                        $product->{'status'} =  $product->status;
                    }
                });
        }

        return response()->json([
            'status' => 'SUCCESS',
            'products' => $products,
        ]);
    }

    public function referList()
    {
        $refer_list = Reseller::where('refer_id', session()->get('reseller')->username)->orderBy('id', 'desc')->get();
        $reseller = Reseller::where('username', session()->get('reseller')->username)->first();
        return response()->json([
            'status' => 'OK',
            'refer_list' => $refer_list,
            'reseller' => $reseller,
        ]);
    }

   

    public function aboutUs()
    {
        $page = 'about-us';
        $about = Page::where('name', $page)->first();
        return response()->json([
            'status' => 'SUCCESS',
            'about' => $about,
        ]);
    }

    public function contactUs()
    {
        $page = 'contact-us';
        $contact = Page::where('name', $page)->first();
        return response()->json([
            'status' => 'SUCCESS',
            'contact' => $contact,
        ]);
    }

    public function getSetting()
    {
        $general_setting = ResellerSiteInfo::latest()->first();
        $setting = GeneralSetting::select('id', 'courier_id')->latest()->first();
        return response()->json([
            'general_setting' => $general_setting,
            'setting' => $setting,
        ]);
    }

    

    public function getDropshipperInfo()
    {
        $dropshipper = Reseller::inRandomOrder()
            ->limit(1)
            ->get();
        return response()->json([
            'dropshipper' => $dropshipper,
        ]);
    }

    public function getDropshipperProduct()
    {
        $dropshipper_product = Product::select(
                'id',
                'category_id',
                'name',
                'sale_price',
                'price',
                'reselling_price',
                'thumbnail_img',
                'input_qty'
            )
            ->with('productVariant.variant', 'resellerProductPrice')
            ->inRandomOrder()
            ->limit(2)
            ->get();
        return response()->json([
            'dropshipper_product' => $dropshipper_product,
        ]);
    }

   

    public function countDropshipper()
    {
        $total_dropshipper = Reseller::count();
        return response()->json([
            'total_dropshipper' => $total_dropshipper,
        ]);
    }

    public function allCategory()
    {
        $categories = Category::query()->select('id', 'name', 'slug', 'icon_image')->whereHas('product', function ($query) {
            return $query->where('category_id', '!=', null);
        })->get();
        return response()->json([
            'categories' => $categories,
        ]);
    }

    /* Category Wise Subcategory and Product */
    public function categoryWiseSubcategoryAndProduct()
    {
        $categories = Category::query()->select('id', 'name', 'slug', 'icon_image')->whereHas('product', function ($query) {
            return $query->where('category_id', '!=', null);
        })->paginate(3);

        foreach ($categories as $category) {
            $category->{'products'} = Product::where('category_id', $category->id)
                ->orderBy('product_position', 'ASC')
                ->where('status', 1)
                ->select('id', 'name', 'product_code', 'details', 'price', 'stock', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img', 'input_qty')
                ->with('productImage', 'productVariant.variant', 'resellerProductPrice')
                ->get();
            // ->take(10);
        }



        return response()->json([
            'status' => true,
            'categories' => $categories,
        ]);
    }







    public function subCategories()
    {
        $sub_categories = SubCategory::where('status', 1)->get();
        return response()->json([
            'success' => true,
            'sub_categories' => $sub_categories,
        ]);
    }


    public function subSubCategories()
    {
        $sub_sub_categories = SubSubCategory::where('status', 1)->get();
        return response()->json([
            'success' => true,
            'sub_sub_categories' => $sub_sub_categories,
        ]);
    }

    public function categoryWiseProduct($categorySlug)
    {
        try {

            $category = Category::where('slug', $categorySlug)->first();
            $products = Product::with('productImage', 'productVariant.variant', 'resellerProductPrice')->where('category_id', $category->id)->orderBy('id', 'desc')
                ->where('status', 1)
                ->select('id', 'name', 'slug', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'reselling_price', 'thumbnail_img', 'details', 'input_qty')
                ->get();
            $category->visitor = (intval($category->visitor) + 1);
            $category->save();
            return response()->json([
                'products' => $products,
            ]);
        } catch (Exception $e) {
            return response()->json([
                'products' => [],
            ]);
        }
    }

    /* new product */
    public function newArrivalProduct()
    {
        $products = Product::with('productVariant.variant')->select('id', 'name', 'slug', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'reselling_price', 'thumbnail_img', 'details', 'input_qty')
            ->latest()->take(10)->orderBy('updated_at', 'ASC')->get();
        return response()->json([
            'products' => $products,
        ]);
    }

    /* Category Wise Product */
    public function subcategoryWiseProducts()
    {

        $sub_categories = SubCategory::orderBy('position', 'ASC')
            ->where('status', 1)
            ->where('show_homepage', 1)
            ->select('id', 'name', 'slug', 'category_id')
            ->with(['category:id,name,slug', 'subSubCategory:id,name,slug'])
            ->paginate(2);

        foreach ($sub_categories as $sub_category) {
            $sub_category->{'products'} = Product::where('sub_category_id', $sub_category->id)
                ->orderBy('product_position', 'ASC')
                ->where('status', 1)
                ->select('id', 'name', 'price', 'stock', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img', 'input_qty')
                ->with('productAttribute', 'resellerProductPrice')
                ->get()
                ->take(10);
        }
        return response()->json([
            'status' => true,
            'sub_categories' => $sub_categories
        ]);
    }





    public function getProducts()
    {
        $products = Product::with('productImage', 'productVariant.variant', 'resellerProductPrice')
            ->select('id', 'name', 'slug', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'reselling_price', 'thumbnail_img', 'details', 'input_qty')
            ->orderBy('id', 'desc')->paginate(10);
        return response()->json([
            'status' => true,
            'products' => $products,
        ]);
    }

    /* =========================== Category And SubCategory Wise Product ================================== */
    public function categoryWiseSubcategory($slug)
    {
        $category_id =  Category::where('slug', $slug)->pluck('id');
        $sub_categories =   SubCategory::where('category_id', $category_id)->get();


        return response()->json([
            'status' => 'SUCCESS',
            'sub_categories' => $sub_categories
        ]);
    }

    public function subCategoryWiseProduct(Request $request)
    {
        if ($request->sub_category_id == null) {
            $category_id =  Category::where('slug', $request->category_slug)->pluck('id');
            $products = Product::with('productImage', 'productVariant.variant', 'resellerProductPrice')
                ->where('show_homepage', 1)
                ->where('category_id', $category_id)
                ->select('id', 'name', 'slug', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'reselling_price', 'thumbnail_img', 'details', 'input_qty')
                ->get();
        } else {
            $products = Product::with('productImage', 'productVariant.variant', 'resellerProductPrice')
                ->where('show_homepage', 1)
                ->where('sub_category_id', $request->sub_category_id)
                ->select('id', 'name', 'slug', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'stock', 'product_code', 'price', 'sale_price', 'reselling_price', 'thumbnail_img', 'details', 'input_qty')
                ->get();
        }

        return response()->json([
            'status' => 'SUCCESS',
            'products' => $products
        ]);
    }
    /* =========================== Category And SubCategory Wise Product ================================== */


    public function pages()
    {
        $pages = Page::whereNull('reseller_id')->get();
        return response()->json([
            'status' => 'SUCCESS',
            'pages' => $pages
        ]);
    }
    public function showPageInfo($slug)
    {
        $pageInfo = Page::where('name', $slug)->first();
        return response()->json([
            'status' => 'SUCCESS',
            'pageInfo' => $pageInfo
        ]);
    }

    public function singleProduct($id)
    {
        $product = Product::findOrFail($id);
        $productImage = ProductImage::where('product_id', $product->id)->get();
        $productAttribute = ProductAttribute::where('product_id', $product->id)->get();
        $productVariant = ProductVariant::with('variant')->where('product_id', $product->id)->get();
        return response()->json([
            'status' => true,
            'product' => $product,
            'productImage' => $productImage,
            'productAttribute' => $productAttribute,
            'productVariant' => $productVariant,
        ]);
    }




    /* ========================= Order Store ========================== */
    public function getCartContent()
    {
        $cart_content = Cart::content();
        $cart_total = Cart::total();

        return response()->json([
            'status' => 'SUCCESS',
            'cart_total' => $cart_total,
            'cart_content' => $cart_content,
            'item_count' => Cart::count(),
        ]);
    }

    public function addToCart(Request $request)
    {
        $product = Product::where('id', $request->product_id)->firstOrFail();
        $variant = Variant::select('id', 'name')->where('id', $request->variant_id)->first();

        $add = Cart::add([
            'id' => $product->id,
            'name' => $product->name,
            'slug' => $product->slug,
            'qty' => $request->qty ?? 1,
            'price' => $product->sale_price,
            'price' => $request->reseller_username ? $product->reselling_price : $product->sale_price,
            'weight' => 0,
            'tax' => 0,
            'options' => [
                'image' => $product->thumbnail_img,
                'resale_price' => $product->reselling_price,
                'custom_resale' => $product->reselling_price,
                'variant_id' => $variant->id ?? null,
                'variant_name' => $variant->name ?? null
            ],
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Successfully added new product in cart',
        ]);
    }

    public function cartUpdate(Request $request)
    {
        $request->validate([
            'qty' => 'required|numeric|min:1',
        ]);
        $edit = Cart::update($request->rowId, $request->qty);
        if (Cart::content()->has($edit->rowId)) {
            return $this->index();
        }
    }



    public function cartRemoveItem($rowId)
    {
        Cart::remove($rowId);
        return $this->index();
    }

    public function cartClearAll()
    {
        Cart::destroy();
        return response()->json([
            'status' => true,
            'message' => 'Successfully destroy in all product cart'
        ]);
    }



    public function resellerProductEdit($id)
    {
        $reseller_price = ResellerProductPrice::where('product_id', $id)->where('reseller_id', session()->get('reseller')['id'])->with('main_product:id,sale_price')->first();
        if ($reseller_price) {
            return response()->json([
                'status' => 'SUCCESS',
                'reseller_price' => $reseller_price,
            ]);
        } else {
            $product = Product::findOrFail($id);
            return response()->json([
                'status' => 'SUCCESS',
                'product' => $product,
            ]);
        }
    }



    public function resellerResellingPriceUpdate(Request $request, $id)
    {
        $request->validate([
            'reselling_price' => 'required'
        ]);
        $reseller_id = session()->get('reseller')['id'];
        $product = Product::findOrFail($id);
        $reselling_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', $reseller_id)->first();
        if ($reselling_price) {
            $reselling_price->price = $request->reselling_price;
            $reselling_price->sale_price = $request->reselling_sale_price;
            $reselling_price->save();
            return response()->json([
                'success' => true,
                'message' => 'Price Updated'
            ]);
        } else {
            $reseller_price = new ResellerProductPrice();
            $reseller_price->product_id = $product->id;
            $reseller_price->price = $request->reselling_price;
            $reseller_price->sale_price = $request->reselling_sale_price;
            $reseller_price->reseller_id = $reseller_id;
            $reseller_price->save();
            return response()->json([
                'success' => true,
                'message' => 'Price Updated'
            ]);
        }
    }




    public function activeBank()
    {
        $banks = Bank::where('status', 1)->orderby('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'banks' => $banks,
        ]);
    }




    public function productStatus($id)
    {
        $product = Product::findOrFail($id);
        $reseller_id = session()->get('reseller')['id'];
        $reselling_product = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', $reseller_id)->first();
        if ($reselling_product) {
            if ($reselling_product->status == 1) {
                $reselling_product->status = 0;
                $reselling_product->save();
            } else {
                $reselling_product->status = 1;
                $reselling_product->save();
            }
        } else {
            $reselling_product = new ResellerProductPrice();
            $reselling_product->product_id = $product->id;
            $reselling_product->price = $product->reselling_price;
            $reselling_product->sale_price = $product->reselling_price;
            $reselling_product->reseller_id = $reseller_id;
            if ($product->status == 1) {
                $reselling_product->status = 0;
            } else {
                $reselling_product->status = 1;
            }
            $reselling_product->save();
        }
        return response()->json([
            'success' => true,
            'message' => 'Status Changed',
        ]);
    }






    public function customer()
    {
        $customers = Customer::where('reseller_id', session()->get('reseller')['id'])->orderBy('id', 'DESC')->with('customerCity')->paginate(20);
        return response()->json([
            'success' => true,
            'customers' => $customers,
        ]);
    }

    public function searchCustomer($search)
    {
        $reseller_id = session()->get('reseller')['id'];
        $customers = Customer::where('name', 'like', '%' . $search . '%')->orWhere('phone', 'like', '%' . $search . '%')->where('reseller_id', $reseller_id)->with('customerCity')->paginate(20);
        return response()->json([
            'success' => true,
            'customers' => $customers,
        ]);
    }


    public function exportCustomer()
    {
        $reseller_id = session()->get('reseller')['id'];
        $filename = 'export-customer-' . date('d-m-Y') . '.csv';
        $file = fopen($filename, "w");
        fputcsv($file, array(
            'SN' => 'SN',
            'Name' => 'Name',
            'Phone' => 'Phone',
            'City' => 'City',
            'Address' => 'Address',
        ));
        $customers = Customer::where('reseller_id', $reseller_id)->with('customerCity')->get();
        foreach ($customers as $k => $customer) {
            fputcsv($file, array(
                'SN' =>  $k + 1,
                'Name' => $customer->name,
                'Phone' => $customer->phone,
                'City' => $customer->customerCity->name,
                'Address' => $customer->address,
            ));
        }
        fclose($file);
        return Response::download('./' . $filename);
    }



    public function apiDocumentation()
    {
        $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
        return response()->json([
            'status' => true,
            'reseller' => $reseller,
        ]);
    }




    public function sendMessage(Request $request)
    {


        $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
        $reseller_cashbook = ResellerCashbook::where('reseller_id', $reseller->id)->get();
        $customers = Customer::where('reseller_id', $reseller->id)->get();
        $general_setting = GeneralSetting::latest()->first();
        $message = $request->message;

        //sms count
        $total_customers = $customers->count();
        $count_char = strlen($message);
        $total_sms = 0;
        if ($count_char < 60) {
            $total_sms += $total_sms + $total_customers;
        } elseif ($count_char > 60 && $count_char < 160) {
            $total_sms += $total_sms + ($total_customers * 2);
        }
        $reseller_current_balance = $reseller_cashbook->where('is_income', 1)->sum('amount') - $reseller_cashbook->where('is_income', 0)->sum('amount');

        //sms count and amount calculation
        $sms_amount = $total_sms * $general_setting->sms_charge;
        if ($sms_amount < $reseller_current_balance) {
            return response()->json([
                'status' => false,
                'message' => 'Sorry, you do not have enough balance.',
            ]);
        } else {
            HelperService::resellerCashbookStore(null, $reseller->id, intval($sms_amount), 0,  intval($sms_amount) . ' tk sms service charge. number of sms ' . $total_sms, 0);
            Customer::sendMessageToResellerCustomer($message, $customers);
        }



        return response()->json([
            'status' => true,
            'message' => 'Message Send',
        ]);
    }



    public function smsHistory()
    {
        $reseller = Reseller::findOrFail(session()->get('reseller')['id']);
        $sms_history = ResellerCashbook::where('note', 'like', '%' . 'sms service charge. number of sms' . '%')->where('reseller_id', session()->get('reseller')['id'])->orderBy('id', 'desc')->get();
        $total_sms_amount = $sms_history->sum('amount');
        $total_sms = 0;
        $total_customer = Customer::where('reseller_id', $reseller->id)->count();
        foreach ($sms_history as $history) {
            $sms_count = trim($history->note);
            $words = explode(' ', $sms_count);
            $sms_number = array_pop($words);
            $total_sms += $sms_number;
        }
        return response()->json([
            'status' => true,
            'sms_history' => $sms_history,
            'total_sms_amount' => $total_sms_amount,
            'total_sms' => $total_sms + $reseller->total_sms,
            'total_customer' => $total_customer,
        ]);
    }



    
}
