<?php

namespace App\Http\Controllers\Reseller;

use Exception;
use App\Models\Product;
use App\Models\LandingPage;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\ResellerProductPrice;

class LandingPageController extends Controller
{
    public function pages()
    {
        $reseller_id = session()->get('reseller')['id'];
        $landing_pages = LandingPage::where('reseller_id', $reseller_id)->orderBy('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'landing_pages' => $landing_pages,
        ]);
    }


    public function addPage(Request $request)
    {
        $data = $request->validate([
            'page_name' => 'required|unique:landing_pages',
            'image' => 'required',
        ]);
        DB::beginTransaction();
        try {
            $page = new LandingPage();
            $page->page_name = $request->page_name;
            $page->page_slug = Str::slug($request->page_name);
            $page->main_title = $request->main_title;
            $page->hotline_title = $request->hotline_title;
            $page->hotline_phone = $request->hotline_phone;
            $page->video_title = $request->video_title;
            $page->video_title_two = $request->video_title_two;
            $page->video_title_three = $request->video_title_three;
            $page->video_url = $request->video_url;
            $page->video_url_two = $request->video_url_two;
            $page->video_url_three = $request->video_url_three;
            $page->why_us_title = $request->why_us_title;
            $page->why_us_description = $request->why_us_description;
            $page->solution_title = $request->solution_title;
            $page->benefit_title = $request->benefit_title;
            $page->reseller_id = session()->get('reseller')['id'];
            
            if ($request->hasFile('image')) {
                $path = $request->file('image')->store('images/page', 'public');
                $page->main_banner = $path ;
            }
            if ($request->hasFile('hotline_image')) {
                $path = $request->file('hotline_image')->store('images/page', 'public');
                $page->hotline_image = $path ;
            }
            if ($request->hasFile('benefit_image')) {
                $path = $request->file('benefit_image')->store('images/page', 'public');
                $page->benefit_image = $path ;
            }
            // return 'test';
            $page->save();

            if(!empty($request->products)){
                $reselling_price = ResellerProductPrice::where('product_id', $request->products[0]['id'])->where('reseller_id', $page->reseller_id)->first();
                if($reselling_price){
                    $reselling_price->is_auto_cart = 1;
                    $reselling_price->landing_page_id = $page->id;
                    $reselling_price->save();
                }else{
                    $auto_cart_product = Product::findOrFail($request->products[0]['id']);
                    $reseller_price = new ResellerProductPrice();
                    $reseller_price->product_id = $auto_cart_product->id;
                    $reseller_price->price = $auto_cart_product->reselling_price;
                    $reseller_price->sale_price = $auto_cart_product->reselling_price;
                    $reseller_price->reseller_id = $page->reseller_id;
                    $reseller_price->is_auto_cart = 1;
                    $reseller_price->landing_page_id = $page->id;
                    $reseller_price->save();
                }
                


                foreach($request->products as $product){
                    $reselling_price = ResellerProductPrice::where('product_id', $product['id'])->where('reseller_id', $page->reseller_id)->first();
                    if($reselling_price){
                        $reselling_price->landing_page_id = $page->id;
                        $reselling_price->save();
                    }else{
                        $product = Product::findOrFail($product['id']);
                        $reseller_price = new ResellerProductPrice();
                        $reseller_price->product_id = $product->id;
                        $reseller_price->price = $product->reselling_price;
                        $reseller_price->sale_price = $product->reselling_price;
                        $reseller_price->reseller_id = $page->reseller_id;
                        $reseller_price->landing_page_id = $page->id;
                        $reseller_price->save();
                    }
                }
            }

            DB::commit();
            return response()->json([
                'success' =>true,
                'message' => 'Added successfully',
            ]);
        }catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }


    public function update(Request $request , $id){
        $data = $request->validate([
            'page_name' => 'required',
            'hotline_title' => 'required',
            'hotline_phone' => 'required',
            'page_slug' => 'required|unique:landing_pages,page_slug,' .$id,
        ]);
        DB::beginTransaction();
        try {
            $page = LandingPage::find($id);
            $page->page_name = $request->page_name;
            $page->page_slug = Str::slug($request->page_slug);
            $page->main_title = $request->main_title;
            $page->hotline_title = $request->hotline_title;
            $page->hotline_phone = $request->hotline_phone;
            $page->video_title = $request->video_title;
            $page->video_title_two = $request->video_title_two;
            $page->video_title_three = $request->video_title_three;
            $page->video_url = $request->video_url;
            $page->video_url_two = $request->video_url_two;
            $page->video_url_three = $request->video_url_three;
            $page->why_us_title = $request->why_us_title;
            $page->why_us_description = $request->why_us_description;
            $page->solution_title = $request->solution_title;
            $page->benefit_title = $request->benefit_title;
            $page->reseller_id = session()->get('reseller')['id'];
            if ($request->hasFile('image')) {
                $path = $request->file('image')->store('images/page', 'public');
                $page->main_banner=$path ;
            }


            if ($request->hasFile('hotline_image')) {
                $path = $request->file('hotline_image')->store('images/page', 'public');
                $page->hotline_image=$path ;
            }

            if ($request->hasFile('benefit_image')) {
                $path = $request->file('benefit_image')->store('images/page', 'public');
                $page->benefit_image=$path ;
            }

            if(!empty($request->products)){
                $reselling_price = ResellerProductPrice::where('product_id', $request->products[0]['product_id'])->where('reseller_id', $page->reseller_id)->first();
                if($reselling_price){
                    $reselling_price->is_auto_cart = 1;
                    $reselling_price->landing_page_id = $page->id;
                    $reselling_price->save();
                }else{
                    $auto_cart_product = Product::findOrFail($request->products[0]['product_id']);
                    $reseller_price = new ResellerProductPrice();
                    $reseller_price->product_id = $auto_cart_product->id;
                    $reseller_price->price = $auto_cart_product->reselling_price;
                    $reseller_price->sale_price = $auto_cart_product->reselling_price;
                    $reseller_price->reseller_id = $page->reseller_id;
                    $reseller_price->is_auto_cart = 1;
                    $reseller_price->landing_page_id = $page->id;
                    $reseller_price->save();
                }
                


                foreach($request->products as $product){
                    $reselling_price = ResellerProductPrice::where('product_id', $product['product_id'])->where('reseller_id', $page->reseller_id)->first();
                    if($reselling_price){
                        $reselling_price->landing_page_id = $page->id;
                        $reselling_price->save();
                    }else{
                        $product = Product::findOrFail($product['product_id']);
                        $reseller_price = new ResellerProductPrice();
                        $reseller_price->product_id = $product->id;
                        $reseller_price->price = $product->reselling_price;
                        $reseller_price->sale_price = $product->reselling_price;
                        $reseller_price->reseller_id = $page->reseller_id;
                        $reseller_price->landing_page_id = $page->id;
                        $reseller_price->save();
                    }
                }
            }
            $page->save();
            DB::commit();
            return response()->json([
                'success' =>true,
                'message' => 'Updated successfully',
            ]);
        }catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
        
    }


    public function edit($id)
    {
        $page = LandingPage::with('resellerProductPrice')->findOrFail($id);
        return response()->json([
            'success' => true,
            'page' => $page,
        ]);
    }




    public function status($id)
    {
        $page = LandingPage::findOrFail($id);
        if($page->status == 1){
            $page->status = 0;
            $page->save();
        }else{
            $page->status = 1;
            $page->save(); 
        }

        return response()->json([
            'success' => true,
            'message' => 'Updated successfully',
        ]);
    }



    public function activePage()
    {
        $reseller_id = session()->get('reseller')['id'];
        $landing_pages = LandingPage::where('reseller_id', $reseller_id)->where('status', 1)->orderBy('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'pages' => $landing_pages,
        ]);
    }



    public function removeProduct(Request $request)
    {
        $reseller_id = session()->get('reseller')['id'];
        $product = ResellerProductPrice::where('reseller_id', $reseller_id)->where('product_id', $request->landing_product_id)->first();
        $product->is_auto_cart = 0;
        $product->landing_page_id = null;
        $product->save();
        return response()->json([
            'success' => true,
            'message' => 'Saved',
        ]);
    }
}
