<?php

namespace App\Http\Controllers\Reseller;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use App\Models\Page;

class PageController extends Controller
{
    public function index(){

        $pages = Page::where('reseller_id', session()->get('reseller')['id'])->orderBy('id', 'desc')->get();
         return response()->json([
            'status' => 'SUCCESS',
            'pages' => $pages
        ]);

    }



    public function store(Request $request){

        $this->validate($request, [
            'name' => 'required',
            'details' => 'required',
        ]);

        $page = new Page();
        $page->name = $request->name;
        $page->reseller_id = session()->get('reseller')['id'];
        $page->slug = Str::slug($request->name) . $page->reseller_id;
        $page->details = $request->details;
        $page->save();

        return response()->json([
            'status' => 'SUCCESS',
            'message' => "page added successfully"
        ]);

    }





    public function edit($id){

        $page = Page::findOrFail($id);
        return response()->json([
            'status' => 'SUCCESS',
            'page' => $page
        ]);

    }




    public function update(Request $request, $id){



        $this->validate($request, [
            'name' => 'required',
            'details' => 'required',
        ]);

        $page = Page::findOrFail($id);
        $page->name = $request->name;
        $page->reseller_id = session()->get('reseller')['id'];
        $page->slug = Str::slug($request->name) . $page->reseller_id;
        $page->details = $request->details;
        $page->save();

        return response()->json([
            'status' => 'SUCCESS',
            'message' => "page updated successfully"
        ]);



    }
}
