<?php

namespace App\Http\Controllers\Reseller;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ResellerSlider;
use Exception;
class SliderController extends Controller
{
      public function index()
      {
        $sliders = ResellerSlider::where('reseller_id', session()->get('reseller')['id'])->orderBy('id', 'DESC')->paginate(5);
        return response()->json([
            'success' => true,
            'sliders' => $sliders,
        ]);
      }

      public function edit($id){

        $slider = ResellerSlider::find($id);
        if ($slider) {
            return response()->json([
                'success' => true,
                "slider" => $slider ,
            ]);
        }
      }

      /**
      * Show the form for creating a new resource.
      *
      * @return \Illuminate\Http\Response
      */
      public function create()
      {
      //
      }

      /**
      * Store a newly created resource in storage.
      *
      * @param \Illuminate\Http\Request $request
      * @return \Illuminate\Http\Response
      */
      public function store(Request $request)
      {
        $validatedData = $request->validate([
            'image' => 'required',
            'position' => 'required',
        ]);

        try{
            $slider = new ResellerSlider();
            $slider->status = 1;
            $slider->reseller_id = session()->get('reseller')['id'];
            $slider->position = $request->position;
            $slider->url=$request->url;
            if ($request->hasFile('image')) {
                $path = $request->file('image')->store('images/reseller_slider', 'public');
                $slider->image = $path;
            }
            $slider->save();
            return response()->json([
                'success' => true,
                'message' => 'slider add successfully'
            ]);
        }catch(Exception $e){
            return $e->getMessage();
        }

        
        
        

      }

      public function update(Request $request , $id){


        $validatedData = $request->validate([
            'url' => 'required',
            'position' => 'required',
        ]);

        $slider = ResellerSlider::findOrFail($id);
        $slider->url=$request->url ;
        $slider->position=$request->position;

        if ($request->hasFile('image')) {
            if (file_exists('storage/'.$slider->image)) {
                unlink('storage/'.$slider->image);
            }
            $path = $request->file('image')->store('images/slider', 'public');
            $slider->image=$path ;

        }
        if($slider->save()){
            return response()->json([
                'success' => true,
                'message' => 'slider updated successfully',
            ]);
        }

      }


      
    public function destroy($id)
    {
        $slider = ResellerSlider::findOrFail($id);
        if ($slider) {
            if ($slider->delete()) {
                return response()->json([
                    'success' => true,
                    'message' => 'slider delete successfully'
                ]);
            }
        }
    }


    public function active($id)
    {
        $slider = ResellerSlider::findOrFail($id);
        if ($slider) {
            $slider->status = 1;
            if ($slider->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'slider active successfully'
                ]);
            }
        }
    }

    public function deActive($id)
    {
        $slider = ResellerSlider::findOrFail($id);
            if ($slider) {
            $slider->status = 0;
                if ($slider->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'slider de-active successfully'
                ]);
            }
        }
    }

}